<?php
// wallet_data.php
// خروجی: اطلاعات کیف پول + لیست تراکنش‌ها برای کاربر لاگین‌شده

declare(strict_types=1);

session_start();

// --- تنظیمات هدر خروجی JSON ---
header('Content-Type: application/json; charset=utf-8');

// اگر لاگین نیست
if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'ok'      => false,
        'error'   => 'NOT_LOGGED_IN',
        'message' => 'User is not logged in.',
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

$userId = (int)$_SESSION['user_id'];

// --- اتصال دیتابیس ---
// این بخش رو با فایل/متغیر خودت ست کن.
// فرض: بعد از این include متغیر $pdo از نوع PDO داریم.
require __DIR__ . '/config.php'; // اگر اسمش چیز دیگه‌ایه، عوضش کن

if (!isset($pdo) || !$pdo instanceof PDO) {
    http_response_code(500);
    echo json_encode([
        'ok'      => false,
        'error'   => 'DB_NOT_READY',
        'message' => 'Database connection is not available.',
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

try {
    // --- خواندن موجودی کیف پول از users.wallet_balance (ریال) ---
    $stmtUser = $pdo->prepare('SELECT wallet_balance FROM users WHERE id = :id LIMIT 1');
    $stmtUser->execute([':id' => $userId]);
    $userRow = $stmtUser->fetch(PDO::FETCH_ASSOC);

    if (!$userRow) {
        http_response_code(404);
        echo json_encode([
            'ok'      => false,
            'error'   => 'USER_NOT_FOUND',
            'message' => 'User record not found.',
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit;
    }

    $balance = (int)($userRow['wallet_balance'] ?? 0);

    // --- لیست تراکنش‌های کیف پول (مثلاً آخرین 50 تا) ---
    $stmtTx = $pdo->prepare(
        'SELECT id, amount, type, related_payment_id, related_service_id, description, created_at
         FROM wallet_transactions
         WHERE user_id = :uid
         ORDER BY id DESC
         LIMIT 50'
    );
    $stmtTx->execute([':uid' => $userId]);
    $txRows = $stmtTx->fetchAll(PDO::FETCH_ASSOC);

    $transactions = [];
    foreach ($txRows as $row) {
        $transactions[] = [
            'id'                => (int)$row['id'],
            'amount'            => (int)$row['amount'], // ریال؛ مثبت = شارژ، منفی = خرج
            'type'              => (string)$row['type'],
            'related_payment_id'=> $row['related_payment_id'] !== null ? (int)$row['related_payment_id'] : null,
            'related_service_id'=> $row['related_service_id'] !== null ? (int)$row['related_service_id'] : null,
            'description'       => $row['description'] !== null ? (string)$row['description'] : null,
            'created_at'        => (string)$row['created_at'],
        ];
    }

    // --- خروجی نهایی ---
    echo json_encode([
        'ok'       => true,
        'wallet'   => [
            'balance' => $balance, // ریال
        ],
        'transactions' => $transactions,
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok'      => false,
        'error'   => 'EXCEPTION',
        'message' => 'Unexpected error.',
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    // اگر لاگ داری، اینجا لاگ کن
    // error_log($e->getMessage());
    exit;
}
