<?php
// vpn_factory.php
// کارخانه ساخت کلاینت VPN بر اساس جدول vpn_panels

require_once __DIR__ . '/marzban.php';

class VpnFactory
{
    // اینجا هم بدون تایپ‌پرابرتی
    private $pdo;

    public function __construct($pdo)
    {
        $this->pdo = $pdo;
    }

    /**
     * گرفتن رکورد پنل پیش‌فرض (فعال‌ترین با کمترین sort_order)
     */
    public function getDefaultPanelRow(): ?array
    {
        $sql = "
            SELECT *
            FROM vpn_panels
            WHERE is_active = 1
            ORDER BY sort_order ASC, id ASC
            LIMIT 1
        ";
        $stmt = $this->pdo->query($sql);
        $row  = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row ?: null;
    }

    /**
     * گرفتن رکورد پنل بر اساس id
     */
    public function getPanelById(int $panelId): ?array
    {
        $stmt = $this->pdo->prepare("
            SELECT *
            FROM vpn_panels
            WHERE id = :id
            LIMIT 1
        ");
        $stmt->execute([':id' => $panelId]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row ?: null;
    }

    /**
     * ساخت کلاینت مناسب بر اساس type
     * فعلاً فقط marzban
     */
    public function createClientFromRow(array $panelRow)
    {
        $type = strtolower((string)($panelRow['type'] ?? ''));

        switch ($type) {
            case 'marzban':
                return new MarzbanService($this->pdo, $panelRow);

            // در آینده برای X-UI:
            // case 'xui':
            //     require_once __DIR__ . '/xui.php';
            //     return new XuiService($this->pdo, $panelRow);

            default:
                throw new Exception('نوع پنل پشتیبانی نمی‌شود: ' . $type);
        }
    }

    /**
     * گرفتن کلاینت پنل پیش‌فرض
     */
    public function getDefaultClient()
    {
        $panelRow = $this->getDefaultPanelRow();
        if (!$panelRow) {
            throw new Exception('هیچ پنل فعالی در جدول vpn_panels تعریف نشده است.');
        }

        return $this->createClientFromRow($panelRow);
    }

    /**
     * گرفتن کلاینت بر اساس panel_id
     * (برای وقتی بعداً تو services یا payments panel_id ذخیره کنیم)
     */
    public function getClientByPanelId(int $panelId)
    {
        $panelRow = $this->getPanelById($panelId);
        if (!$panelRow) {
            throw new Exception('پنل مورد نظر در جدول vpn_panels پیدا نشد.');
        }

        return $this->createClientFromRow($panelRow);
    }
}
