<?php
// settings.php
// لودر .env + هِلپرهای تنظیمات + get_plan از دیتابیس

require __DIR__ . '/db.php';

/**
 * لود کردن فایل .env در همون پوشه‌ی پروژه
 * فرمت:
 * ZARINPAL_MERCHANT_ID=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * APP_URL=https://ts.diminet.ir
 */
(function () {
    $envPath = __DIR__ . '/.env';
    if (!is_file($envPath)) {
        return;
    }

    $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if ($lines === false) {
        return;
    }

    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '' || $line[0] === '#') {
            continue;
        }
        if (strpos($line, '=') === false) {
            continue;
        }

        list($name, $value) = explode('=', $line, 2);
        $name  = trim($name);
        $value = trim($value);

        // حذف کوتیشن‌های دور مقدار
        $value = trim($value, " \t\n\r\0\x0B\"'");

        if ($name === '') {
            continue;
        }

        // اگر قبلاً تعریف نشده، ست کن
        if (getenv($name) === false) {
            putenv($name . '=' . $value);
        }
        if (!array_key_exists($name, $_ENV)) {
            $_ENV[$name] = $value;
        }
        if (!array_key_exists($name, $_SERVER)) {
            $_SERVER[$name] = $value;
        }
    }
})();

/**
 * گرفتن مقدار از env (با fallback روی $_ENV و $_SERVER)
 */
function app_env(string $key, $default = null)
{
    $val = getenv($key);
    if ($val === false || $val === '' || $val === null) {
        $val = $_ENV[$key] ?? $_SERVER[$key] ?? null;
    }
    if ($val === null || $val === '') {
        return $default;
    }
    return $val;
}

/**
 * هِلپر تنظیمات منطقی (الان فقط چندتا کلید مهم)
 */
function get_setting(string $key, $default = null)
{
    switch ($key) {
        case 'zarinpal_merchant_id':
            return app_env('ZARINPAL_MERCHANT_ID', $default);

        case 'app_url':
            return app_env('APP_URL', $default);

        default:
            return $default;
    }
}

/**
 * گرفتن اطلاعات پلن از جدول plans
 */
function get_plan(string $code): ?array
{
    global $pdo;

    $stmt = $pdo->prepare("
        SELECT *
        FROM plans
        WHERE code = :c
        LIMIT 1
    ");
    $stmt->execute([':c' => $code]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    return $row ?: null;
}
