<?php
// reset.php
// کاربر با لینکی که ایمیل شده اومده. می‌تونه رمز جدید ست کنه.

session_start();
require __DIR__ . '/db.php';

// helper برای گرفتن رکورد توکن
function get_reset_row(PDO $pdo, string $token) {
    $stmt = $pdo->prepare("SELECT * FROM password_resets WHERE token = :t LIMIT 1");
    $stmt->execute([':t' => $token]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row) return null;

    // چک انقضا
    $expTs = strtotime($row['expires_at'] ?? '');
    if (!$expTs || $expTs < time()) {
        // منقضی شده → پاکش کن
        $pdo->prepare("DELETE FROM password_resets WHERE token = :t")->execute([':t' => $token]);
        return null;
    }
    return $row;
}

$token = trim($_GET['token'] ?? '');
if ($token === '') {
    http_response_code(400);
    exit('درخواست نامعتبر است (توکن وجود ندارد).');
}

$errMsg   = '';
$okMsg    = '';
$showForm = true;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newPass = trim($_POST['new_pass'] ?? '');
    $repPass = trim($_POST['rep_pass'] ?? '');

    if (mb_strlen($newPass) < 6) {
        $errMsg = 'رمز باید حداقل ۶ کاراکتر باشد.';
    } elseif ($newPass !== $repPass) {
        $errMsg = 'رمز و تکرار آن یکی نیست.';
    } else {
        // توکن رو چک کن
        $row = get_reset_row($pdo, $token);
        if (!$row) {
            $errMsg   = 'این لینک منقضی شده است. لطفاً دوباره درخواست بازیابی رمز بدهید.';
            $showForm = false;
        } else {
            $email = $row['email'];

            // آپدیت رمز در جدول users (هش‌شده)
            $hashed = password_hash($newPass, PASSWORD_DEFAULT);

            $stmtU = $pdo->prepare("UPDATE users SET site_password = :p WHERE email = :e LIMIT 1");
            $stmtU->execute([
                ':p' => $hashed,
                ':e' => $email,
            ]);

            // این توکن و هر توکن قبلی رو برای این ایمیل حذف کن
            $pdo->prepare("DELETE FROM password_resets WHERE email = :e")->execute([':e' => $email]);

            // سشن لاگین: بعد از تغییر رمز واردش می‌کنیم
            $_SESSION['user_email'] = $email;

            $okMsg    = 'رمز جدید با موفقیت ثبت شد. در حال حاضر وارد شدید.';
            $showForm = false;
        }
    }
} else {
    // GET: قبل از نمایش فرم، توکن معتبره؟
    $row = get_reset_row($pdo, $token);
    if (!$row) {
        $errMsg   = 'این لینک نامعتبر یا منقضی است. لطفاً دوباره درخواست بازیابی رمز بدهید.';
        $showForm = false;
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>تنظیم رمز جدید | دیمینت</title>
<style>
  /* فونت‌ها */
  @font-face{
    font-family:Vazirmatn;
    src:url('/assets/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');
    font-weight:400;font-style:normal;font-display:swap
  }
  @font-face{
    font-family:Vazirmatn;
    src:url('/assets/fonts/webfonts/Vazirmatn-Medium.woff2') format('woff2');
    font-weight:600;font-style:normal;font-display:swap
  }
  @font-face{
    font-family:Vazirmatn;
    src:url('/assets/fonts/webfonts/Vazirmatn-ExtraBold.woff2') format('woff2');
    font-weight:800;font-style:normal;font-display:swap
  }

  :root{
    --bg: #f5f7fb;
    --card:#ffffff;
    --line:#e5e7eb;
    --line-soft:#f1f5f9;
    --text:#0f172a;
    --muted:#6b7280;
    --primary:#2563eb;
    --primary-600:#1d4ed8;
    --radius-card:16px;
    --shadow-main:0 10px 25px rgba(2,6,23,.06);

    --ok-bg:#ecfdf5;
    --ok-border:#bbf7d0;
    --ok:#16a34a;

    --err-bg:#fef2f2;
    --err-border:#fecaca;
    --err:#ef4444;
  }

  *{
    box-sizing:border-box;
    font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif;
  }

  html, body{
    margin:0;
    padding:0;
    min-height:100vh;
    background:var(--bg);
    color:var(--text);
  }

  /* پس‌زمینه گرادینت متحرک دسکتاپ مثل صفحه اصلی */
  @media(min-width:1024px){
    body{
      position: relative;
      background: transparent;
    }
    body::before{
      content:"";
      position:fixed;
      inset:0;
      z-index:-1;
      background:
        radial-gradient(circle at 20% 30%, rgba(37,99,235,.22) 0%, rgba(255,255,255,0) 60%),
        radial-gradient(circle at 80% 20%, rgba(16,185,129,.18) 0%, rgba(255,255,255,0) 60%),
        radial-gradient(circle at 50% 80%, rgba(168,85,247,.16) 0%, rgba(255,255,255,0) 60%),
        linear-gradient(115deg, #f8fafc 0%, #eef2ff 50%, #f9fafb 100%);
      background-size: 140% 140%;
      animation: bgFloat 6s ease-in-out infinite;
    }
  }
  @keyframes bgFloat {
    0%   { background-position: 0% 0%;   }
    50%  { background-position: 100% 80%; }
    100% { background-position: 0% 0%;   }
  }

  .wrap{
    min-height:100vh;
    display:flex;
    flex-direction:column;
    align-items:center;
    justify-content:center;
    padding:24px 16px;
  }

  /* هدر کوچیک بالا (لوگو + بازگشت) */
  .mini-head{
    width:100%;
    max-width:480px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    background:#fff;
    border:1px solid var(--line);
    border-radius:12px;
    box-shadow:0 10px 25px rgba(2,6,23,.06);
    padding:10px 14px;
    margin-bottom:16px;
  }
  @media(min-width:1024px){
    .mini-head{
      background:radial-gradient(circle at 50% 0%, rgba(255,255,255,.9) 0%, rgba(248,250,252,.75) 70%);
      border:1px solid rgba(148,163,184,.25);
      box-shadow:
        0 40px 80px rgba(15,23,42,.18),
        0 4px 16px rgba(0,0,0,.05);
      backdrop-filter: blur(3px);
    }
  }

  .mh-left a{
    display:inline-flex;
    align-items:center;
    justify-content:center;
    gap:6px;
    text-decoration:none;
    background:#0f172a;
    border:2px solid #0f172a;
    color:#fff;
    font-weight:700;
    font-size:12px;
    line-height:1.2;
    border-radius:10px;
    padding:8px 12px;
    box-shadow:0 8px 20px rgba(0,0,0,.06);
  }
  .mh-left a:hover{
    background:#1e293b;
    border-color:#1e293b;
  }
  @media(min-width:1024px){
    .mh-left a{
      border-radius:12px;
      min-height:36px;
      font-size:12px;
      padding:8px 12px;
      box-shadow:0 16px 32px rgba(15,23,42,.22);
      background:linear-gradient(to bottom right,#0f172a 0%,#1e293b 60%);
      border-color:rgba(15,23,42,.6);
    }
  }

  .mh-right{
    display:flex;
    align-items:center;
    gap:10px;
  }
  .mh-logo{
    width:40px;
    height:40px;
    border-radius:10px;
    background:#fff;
    border:1px solid var(--line);
    box-shadow:0 8px 20px rgba(0,0,0,.04);
    display:flex;
    align-items:center;
    justify-content:center;
    overflow:hidden;
  }
  .mh-logo img{
    width:100%;
    height:100%;
    object-fit:cover;
    display:block;
  }
  @media(min-width:1024px){
    .mh-logo{
      box-shadow:0 16px 32px rgba(37,99,235,.18);
      border:1px solid rgba(37,99,235,.3);
      background:radial-gradient(circle at 30% 30%, #fff 0%, #e0e7ff 60%);
    }
  }

  /* کارت فرم */
  .card{
    width:100%;
    max-width:480px;
    background:var(--card);
    border:1px solid var(--line);
    border-radius:var(--radius-card);
    box-shadow:var(--shadow-main);
    padding:20px;
  }
  @media(min-width:1024px){
    .card{
      background: radial-gradient(circle at 50% 0%, rgba(255,255,255,1) 0%, rgba(248,250,252,1) 70%);
      border:1px solid rgba(148,163,184,.25);
      box-shadow:
        0 40px 80px rgba(15,23,42,.18),
        0 4px 16px rgba(0,0,0,.05);
      backdrop-filter: blur(3px);
    }
  }

  h1{
    margin:0 0 14px;
    font-size:1.1rem;
    font-weight:800;
    text-align:center;
    color:var(--text);
    line-height:1.4;
  }

  .small{
    color:var(--muted);
    font-size:.9rem;
    text-align:center;
    margin:0 0 16px;
    line-height:1.6;
  }

  label{
    display:block;
    font-size:.9rem;
    font-weight:600;
    margin:0 0 6px;
    color:var(--text);
    text-align:right;
  }

  .input{
    width:100%;
    max-width:100%;
    box-sizing:border-box;
    padding:12px 14px;
    border:1px solid var(--line);
    border-radius:10px;
    font-size:15px;
    background:#fff;
    color:var(--text);
    outline:none;
    transition:border .2s,box-shadow .2s;
    direction:ltr;
    text-align:left;
  }
  .input:focus{
    border-color:var(--primary);
    box-shadow:0 0 0 3px rgba(37,99,235,.12);
  }

  .btn{
    width:100%;
    background:var(--primary);
    color:#fff;
    border:none;
    border-radius:10px;
    padding:12px;
    font-weight:800;
    font-size:15px;
    cursor:pointer;
    text-align:center;
    font-family:inherit;
    margin-top:16px;
    transition:background .15s ease, transform .08s ease;
  }
  .btn:hover{
    background:var(--primary-600);
    transform: translateY(-1px);
  }

  /* دکمه لینک‌دار بعد از فرم (رفتن به پنل) */
  .link-btn{
    display:block;
    width:100%;
    text-align:center;
    text-decoration:none;
    background:var(--primary);
    color:#fff;
    border-radius:10px;
    padding:12px;
    font-weight:800;
    font-size:15px;
    margin-top:16px;
    box-shadow:0 10px 24px rgba(37,99,235,.25);
    transition:background .15s ease, transform .08s ease;
  }
  .link-btn:hover{
    background:var(--primary-600);
    transform: translateY(-1px);
  }

  .alert{
    border-radius:10px;
    border:1px solid transparent;
    padding:12px 14px;
    font-size:.9rem;
    font-weight:600;
    line-height:1.6;
    margin-bottom:16px;
    text-align:center;
    word-break:break-word;
  }
  .alert.err{
    background:var(--err-bg);
    border-color:var(--err-border);
    color:var(--err);
  }
  .alert.ok{
    background:var(--ok-bg);
    border-color:var(--ok-border);
    color:var(--ok);
  }

  .after-box{
    text-align:center;
    font-size:.9rem;
    line-height:1.6;
    margin-top:8px;
  }
  .after-box .extra-link{
    margin-top:12px;
    font-size:.9rem;
  }
  .after-box .extra-link a{
    color:var(--primary);
    text-decoration:none;
    font-weight:600;
  }

  @media (max-width:480px){
    .card{
      padding:18px;
    }
  }

  input, button {
    font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif !important;
  }
  ::placeholder {
    font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
  }
          .input::placeholder {
      direction:rtl;
      text-align:right;
}


</style>
</head>
<body>

<div class="wrap">

  <!-- هدر بالای کارت -->
  <div class="mini-head">
    <div class="mh-left">
      <a href="index.php">بازگشت</a>
    </div>
    <div class="mh-right">
      <div class="mh-logo">
        <img src="/assets/favicon.png" alt="Diminet">
      </div>
    </div>
  </div>

  <!-- کارت تغییر رمز -->
  <div class="card">
    <h1>تنظیم رمز جدید</h1>

    <?php if ($errMsg !== ''): ?>
      <div class="alert err"><?= htmlspecialchars($errMsg) ?></div>
    <?php endif; ?>

    <?php if ($okMsg !== ''): ?>
      <div class="alert ok"><?= htmlspecialchars($okMsg) ?></div>
    <?php endif; ?>

    <?php if ($showForm): ?>
      <p class="small">رمز جدید خود را وارد کنید. حداقل ۶ کاراکتر.</p>

      <form method="post" autocomplete="off">
        <label for="new_pass"></label>
        <input class="input" id="new_pass" name="new_pass" type="password" minlength="6" placeholder="رمز جدید" required>

        <label for="rep_pass"></label>
        <input class="input" id="rep_pass" name="rep_pass" type="password" minlength="6" placeholder="تکرار رمز جدید" required>

        <button class="btn" type="submit">ثبت رمز جدید</button>
      </form>

    <?php else: ?>
      <div class="after-box">
        <a class="link-btn" href="/index.php?tab=panel">رفتن به پنل</a>

        <?php if ($okMsg === ''): ?>
          <div class="extra-link">
            <a href="/forgot.php">ارسال لینک جدید بازیابی</a>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>

  </div><!-- /card -->
</div><!-- /wrap -->

</body>
</html>
