<?php
// request.php (PDO + settings) — با پشتیبانی «تمدید»، «مبلغ صفر/رایگان» و «شارژ کیف پول»
require __DIR__ . '/db.php';
require __DIR__ . '/settings.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405); exit('Method Not Allowed');
}

$email     = trim($_POST['email'] ?? '');
$planCode  = trim($_POST['plan']  ?? '');
$renewUser = trim($_POST['renew_username'] ?? ''); // در حالت تمدید از index.php می‌آید

// مود کیف پول
$walletMode         = isset($_POST['wallet_mode']) ? (int)$_POST['wallet_mode'] : 0;
$walletAmountToman  = (int)($_POST['wallet_amount_toman'] ?? 0);

if (!$email) {
  exit('ایمیل وارد نشده است.');
}

// نوع پرداخت برای جدول payments.kind
$kind = 'service';

/*
 * اگر wallet_mode فعال باشد، اصلاً سراغ get_plan نمی‌رویم
 * و مبلغ را از wallet_amount_toman می‌گیریم.
 */
if ($walletMode) {
  if ($walletAmountToman < 10000) {
    exit('مبلغ شارژ کیف پول نامعتبر است.');
  }
  $amountRial = $walletAmountToman * 10;
  $planCode   = 'WALLET'; // در جدول payments برای تشخیص شارژ کیف پول استفاده می‌شود
  $renewUser  = '';       // در شارژ کیف پول کاری با renew نداریم
  $kind       = 'wallet';
} else {
  if (!$planCode) {
    exit('ایمیل یا پلن وارد نشده است.');
  }

  $plan = get_plan($planCode);
  if (!$plan) exit('پلن نامعتبر است.');

  $amountRial = (int)$plan['amount_rial'];
  $kind       = 'service';
}

$merchantID = get_setting('zarinpal_merchant_id');
if ($amountRial > 0 && !$merchantID) exit('تنظیم مرچنت زرین‌پال در دسترس نیست.');

/* اطمینان از جدول payments و ستون‌های مورد نیاز */
$pdo->exec("
CREATE TABLE IF NOT EXISTS payments (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(255) NOT NULL,
  plan VARCHAR(32) NOT NULL,
  kind ENUM('service','wallet') NOT NULL DEFAULT 'service',
  renew_username VARCHAR(255) NULL,
  amount_rial BIGINT NOT NULL,
  authority VARCHAR(128) DEFAULT NULL,
  ref_id VARCHAR(64) DEFAULT NULL,
  status ENUM('pending','paid','failed') NOT NULL DEFAULT 'pending',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

// اگر ستون renew_username نبود، اضافه شود
$chk = $pdo->prepare("
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'renew_username'
");
$chk->execute();
if ((int)$chk->fetchColumn() === 0) {
  $pdo->exec("ALTER TABLE payments ADD COLUMN renew_username VARCHAR(255) NULL AFTER plan");
}

// اگر ستون kind نبود، اضافه شود
$chkKind = $pdo->prepare("
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'kind'
");
$chkKind->execute();
if ((int)$chkKind->fetchColumn() === 0) {
  $pdo->exec("ALTER TABLE payments ADD COLUMN kind ENUM('service','wallet') NOT NULL DEFAULT 'service' AFTER plan");
}

/* آدرس بازگشت */
$callbackURL = 'https://' . $_SERVER['HTTP_HOST'] . '/callback.php';

/* ————— مبلغ صفر: فقط در حالت خرید پلن ————— */
if (!$walletMode && $amountRial === 0) {
  $ref = 'FREE-' . strtoupper(bin2hex(random_bytes(4)));

  $ins = $pdo->prepare("
    INSERT INTO payments (email, plan, kind, renew_username, amount_rial, status, ref_id)
    VALUES (:e, :p, :k, :r, 0, 'paid', :ref)
  ");
  $ins->execute([
    ':e'   => $email,
    ':p'   => $planCode,
    ':k'   => 'service', // پرداخت رایگان فقط برای سرویس
    ':r'   => ($renewUser !== '' ? $renewUser : null),
    ':ref' => $ref,
  ]);
  $paymentId = (int)$pdo->lastInsertId();

  // می‌فرستیم سمت callback تا مثل پرداخت موفق معمولی، سرویس بسازد/تمدید کند
  header("Location: {$callbackURL}?free=1&pid={$paymentId}");
  exit;
}

/* ————— مبلغ > ۰: روال عادی زرین‌پال ————— */
// درج رکورد pending
$ins = $pdo->prepare("
  INSERT INTO payments (email, plan, kind, renew_username, amount_rial)
  VALUES (:e, :p, :k, :r, :a)
");
$ins->execute([
  ':e' => $email,
  ':p' => $planCode,
  ':k' => $kind, // 'wallet' یا 'service'
  ':r' => ($renewUser !== '' ? $renewUser : null),
  ':a' => $amountRial
]);
$paymentId = (int)$pdo->lastInsertId();

// ساخت نام نمایشی از ایمیل (بخش قبل از @)، تمیز و خوانا
$localPart   = explode('@', $email)[0] ?? '';
$displayName = preg_replace('/[._\-]+/', ' ', $localPart);
$displayName = trim($displayName);
if ($displayName === '') $displayName = 'کاربر';
if (function_exists('mb_convert_case')) {
  $displayName = mb_convert_case($displayName, MB_CASE_TITLE, 'UTF-8');
} else {
  $displayName = ucwords(strtolower($displayName));
}

// متن توضیحات برای زرین‌پال
if ($walletMode) {
  // حالت شارژ کیف پول
  $description = "شارژ کیف پول به مبلغ {$walletAmountToman} تومان | شماره سفارش: {$paymentId} | خریدار: {$displayName}\n"
               . "ایمیل پرداخت کننده: {$email}";
} else {
  // حالت خرید/تمدید پلن
  if ($renewUser !== '') {
    // حالت تمدید
    $description = "تکرار خرید {$renewUser} | شماره سفارش: {$paymentId} | خریدار: {$displayName}\n"
                 . "ایمیل پرداخت کننده: {$email}";
  } else {
    // حالت خرید
    $description = "خرید به شماره سفارش: {$paymentId} | خریدار: {$displayName}\n"
                 . "ایمیل پرداخت کننده: {$email}";
  }
}

// درخواست به زرین‌پال
$data = [
  'merchant_id'  => $merchantID,
  'amount'       => $amountRial,
  'callback_url' => $callbackURL,
  'description'  => $description,
];

$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST           => true,
  CURLOPT_HTTPHEADER     => ['Content-Type: application/json','Accept: application/json'],
  CURLOPT_POSTFIELDS     => json_encode($data, JSON_UNESCAPED_UNICODE)
]);
$response = curl_exec($ch);
curl_close($ch);

$res = json_decode($response, true);
if (!empty($res['data']['authority'])) {
  $authority = $res['data']['authority'];
  $pdo->prepare("UPDATE payments SET authority=:a WHERE id=:id")
      ->execute([':a'=>$authority, ':id'=>$paymentId]);
  header("Location: https://www.zarinpal.com/pg/StartPay/{$authority}");
  exit;
}

http_response_code(400);
echo 'خطا در ایجاد پرداخت: ' . htmlspecialchars($response);
