<?php
// refund_request_submit.php
header('Content-Type: application/json; charset=utf-8');

// TODO: این رو با اینکلود اصلی پروژه‌ات عوض کن که $pdo رو ست می‌کنه
// مثلا:
require __DIR__ . '/db.php';

if (!isset($pdo) || !($pdo instanceof PDO)) {
    echo json_encode([
        'ok'      => false,
        'message' => 'اتصال به پایگاه داده برقرار نیست.'
    ]);
    exit;
}

$serviceUsername = trim($_POST['service_username'] ?? '');
$reasonText      = trim($_POST['reason'] ?? '');

// 0) اعتبارسنجی ورودی‌ها (سرویس و دلیل)
if ($serviceUsername === '' || $reasonText === '') {
    echo json_encode([
        'ok'      => false,
        'message' => 'درخواست نامعتبر است. لطفاً سرویس و دلیل را ارسال کن.'
    ]);
    exit;
}

if (mb_strlen($reasonText, 'UTF-8') < 10) {
    echo json_encode([
        'ok'      => false,
        'message' => 'لطفاً دلیل عودت وجه را با جزئیات بنویس (حداقل ۱۰ کاراکتر).'
    ]);
    exit;
}

try {
    // 1) سرویس را پیدا کن
    $svcStmt = $pdo->prepare("
        SELECT
            id,
            user_id,
            used_bytes,
            created_at,
            TIMESTAMPDIFF(HOUR, created_at, NOW()) AS diff_hours
        FROM services
        WHERE marzban_user = :u
        LIMIT 1
    ");
    $svcStmt->execute([':u' => $serviceUsername]);
    $svc = $svcStmt->fetch(PDO::FETCH_ASSOC);

    if (!$svc) {
        echo json_encode([
            'ok'      => false,
            'message' => 'سرویس در سیستم یافت نشد.'
        ]);
        exit;
    }

    $serviceId  = (int)$svc['id'];
    $userId     = (int)$svc['user_id'];
    $usedBytes  = (int)($svc['used_bytes'] ?? 0);
    $diffHours  = (int)($svc['diff_hours'] ?? 999999);

    // 2) مصرف باید صفر باشد
    if ($usedBytes > 0) {
        echo json_encode([
            'ok'      => false,
            'message' => 'عودت وجه فقط برای سرویس‌هایی است که مصرف ۰ دارند.'
        ]);
        exit;
    }

    // 3) مهلت ۷۲ ساعت از ایجاد سرویس
    if ($diffHours > 72) {
        echo json_encode([
            'ok'      => false,
            'message' => 'مهلت ثبت درخواست عودت وجه (۷۲ ساعت) برای این سرویس به پایان رسیده است.'
        ]);
        exit;
    }

    // 4) دوباره چک کن درخواست pending نداشته باشیم
    $prevReqStmt = $pdo->prepare("
        SELECT id
        FROM refund_requests
        WHERE service_id = :sid
          AND status = 'pending'
        LIMIT 1
    ");
    $prevReqStmt->execute([':sid' => $serviceId]);
    $prevReq = $prevReqStmt->fetch(PDO::FETCH_ASSOC);

    if ($prevReq) {
        echo json_encode([
            'ok'      => false,
            'message' => 'قبلاً برای این سرویس درخواست عودت وجه ثبت شده و در حال بررسی است.'
        ]);
        exit;
    }

    // 5) ثبت درخواست عودت وجه
    $insStmt = $pdo->prepare("
        INSERT INTO refund_requests
            (user_id, service_id, payment_id, status, reason, requested_at)
        VALUES
            (:uid, :sid, NULL, 'pending', :reason, NOW())
    ");

    $insStmt->execute([
        ':uid'    => $userId,
        ':sid'    => $serviceId,
        ':reason' => $reasonText,
    ]);

    echo json_encode([
        'ok'      => true,
        'message' => 'درخواست عودت وجه با موفقیت ثبت شد. تا ۲۴ ساعت آینده نتیجه از طریق اعلان بهت اطلاع داده می‌شود.'
    ]);
    exit;

} catch (Throwable $e) {
    // می‌تونی این رو لاگ کنی:
    // error_log('refund_request_submit error: ' . $e->getMessage());
    echo json_encode([
        'ok'      => false,
        'message' => 'خطا در ثبت درخواست عودت. لطفاً بعداً دوباره تلاش کن.'
    ]);
    exit;
}
