<?php
// refund_request_check.php
header('Content-Type: application/json; charset=utf-8');

// TODO: این رو با اینکلود اصلی پروژه‌ات عوض کن که $pdo رو ست می‌کنه
// مثلا:
require __DIR__ . '/db.php';
// الان فرض می‌کنیم $pdo موجوده

if (!isset($pdo) || !($pdo instanceof PDO)) {
    echo json_encode([
        'ok'          => false,
        'can_request' => false,
        'message'     => 'اتصال به پایگاه داده برقرار نیست.'
    ]);
    exit;
}

$serviceUsername = trim($_POST['service_username'] ?? '');

// 0) ولیدیشن اولیه
if ($serviceUsername === '') {
    echo json_encode([
        'ok'          => false,
        'can_request' => false,
        'message'     => 'سرویس نامعتبر است.'
    ]);
    exit;
}

try {
    // 1) سرویس مربوطه را پیدا کن
    $svcStmt = $pdo->prepare("
        SELECT
            id,
            user_id,
            used_bytes,
            created_at,
            TIMESTAMPDIFF(HOUR, created_at, NOW()) AS diff_hours
        FROM services
        WHERE marzban_user = :u
        LIMIT 1
    ");
    $svcStmt->execute([':u' => $serviceUsername]);
    $svc = $svcStmt->fetch(PDO::FETCH_ASSOC);

    if (!$svc) {
        echo json_encode([
            'ok'          => false,
            'can_request' => false,
            'message'     => 'سرویس در سیستم یافت نشد.'
        ]);
        exit;
    }

    $serviceId  = (int)$svc['id'];
    $userId     = (int)$svc['user_id'];
    $usedBytes  = (int)($svc['used_bytes'] ?? 0);
    $diffHours  = (int)($svc['diff_hours'] ?? 999999);

    // 2) مصرف باید صفر باشد
    if ($usedBytes > 0) {
        echo json_encode([
            'ok'          => false,
            'can_request' => false,
            'message'     => 'عودت وجه فقط برای سرویس‌هایی است که مصرف ۰ دارند.'
        ]);
        exit;
    }

    // 3) مهلت ۷۲ ساعته از زمان ایجاد سرویس
    if ($diffHours > 72) {
        echo json_encode([
            'ok'          => false,
            'can_request' => false,
            'message'     => 'مهلت ثبت درخواست عودت وجه (۷۲ ساعت) برای این سرویس به پایان رسیده است.'
        ]);
        exit;
    }

    // 4) آیا قبلاً درخواست pending برای این سرویس وجود دارد؟
    $prevReqStmt = $pdo->prepare("
        SELECT id
        FROM refund_requests
        WHERE service_id = :sid
          AND status = 'pending'
        LIMIT 1
    ");
    $prevReqStmt->execute([':sid' => $serviceId]);
    $prevReq = $prevReqStmt->fetch(PDO::FETCH_ASSOC);

    if ($prevReq) {
        echo json_encode([
            'ok'          => false,
            'can_request' => false,
            'message'     => 'قبلاً برای این سرویس درخواست عودت وجه ثبت شده و در حال بررسی است.'
        ]);
        exit;
    }

    // همه‌چیز اوکی 👌
    echo json_encode([
        'ok'          => true,
        'can_request' => true,
        'service_id'  => $serviceId,
        'user_id'     => $userId,
    ]);
    exit;

} catch (Throwable $e) {
    // می‌تونی این رو لاگ کنی:
    // error_log('refund_request_check error: ' . $e->getMessage());
    echo json_encode([
        'ok'          => false,
        'can_request' => false,
        'message'     => 'خطا در پردازش درخواست. لطفاً چند دقیقهٔ دیگر دوباره امتحان کن.'
    ]);
    exit;
}
