<?php
// qr.php
// صفحه‌ی ساخت QR برای لینک اشتراک با استفاده از qr-code-styling (فرانت‌اند)
// مقدار data از query string
$data = isset($_GET['data']) ? trim($_GET['data']) : '';
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>QR اشتراک VPN</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- لایبرری qr-code-styling از CDN -->
  <script src="https://unpkg.com/qr-code-styling@1.6.0/lib/qr-code-styling.js"></script>

  <style>
    * {
      box-sizing: border-box;
    }
    html, body {
      margin: 0;
      padding: 0;
      height: 100%;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
      background: #fff; /* آبی تیره */
      color: #e5e7eb;
    }
    body {
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .qr-shell {
      background: #020617;
      border-radius: 16px;
      padding: 16px 18px 20px;
      box-shadow: 0 18px 45px rgba(15,23,42,0.9);
      text-align: center;
      min-width: 260px;
      max-width: 320px;
    }
    .qr-shell__title {
      font-size: 16px;
      margin: 0 0 8px;
    }
    .qr-shell__subtitle {
      font-size: 12px;
      margin: 0 0 12px;
      color: #9ca3af;
      line-height: 1.6;
    }
    .qr-shell__box {
      background: #ffffff;
      border-radius: 12px;
      padding: 12px;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      margin-bottom: 10px;
    }
    #qr-root {
      width: 240px;
      height: 240px;
    }
    .qr-shell__hint {
      font-size: 11px;
      color: #9ca3af;
      line-height: 1.7;
    }
    .qr-shell__error {
      color: #f97373;
      font-size: 13px;
    }
    .qr-shell__link-preview {
      margin-top: 6px;
      font-size: 11px;
      direction: ltr;
      word-break: break-all;
      color: #cbd5f5;
      opacity: 0.7;
    }
  </style>
</head>
<body>


  <?php if ($data === ''): ?>
    <p class="qr-shell__error">
      داده‌ای برای ساخت QR ارسال نشده است.
    </p>
  <?php else: ?>
    <div class="qr-shell__box">
      <div id="qr-root"></div>
    </div>
  <?php endif; ?>

<?php if ($data !== ''): ?>
<script>
  (function() {
    const data = <?php
      // امن برای JS + حفظ اسلش‌ها و یونیکد
      echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    ?>;

    // اگر چیزی نداشتیم، بی‌خیال
    if (!data) return;

    // ساخت QR با استایل مناسب
    const qrCode = new QRCodeStyling({
      width: 240,
      height: 240,
      data: data,
      type: "svg",
      margin: 8,
      qrOptions: {
        errorCorrectionLevel: "Q"
      },
      dotsOptions: {
        color: "#111827",       // تقریبا مشکی
        type: "rounded"         // گوشه‌های نرم
      },
      backgroundOptions: {
        color: "#ffffff"
      },
      cornersSquareOptions: {
        type: "extra-rounded",
        color: "#0f172a"
      },
      cornersDotOptions: {
        color: "#0f172a"
      }
    });

    const root = document.getElementById("qr-root");
    if (root) {
      qrCode.append(root);
    }
  })();
</script>
<?php endif; ?>

</body>
</html>
