<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$cfgFile = __DIR__ . '/push_secrets.php';

if (!is_file($cfgFile)) {
    echo json_encode([
        'ok'      => false,
        'message' => 'VAPID config not found',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$cfg = require $cfgFile;

$public = $cfg['vapid_public_key'] ?? '';

if (!$public) {
    echo json_encode([
        'ok'      => false,
        'message' => 'VAPID public key is empty',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

echo json_encode([
    'ok'               => true,
    'vapid_public_key' => $public,
], JSON_UNESCAPED_UNICODE);
