<?php
// notifications_mark_read.php
header('Content-Type: application/json; charset=utf-8');

// اینجا کانفیگ و سشن پروژه خودت رو اینکلود کن:
require __DIR__ . '/db.php';   // اگر اسمش چیز دیگه‌ست، عوضش کن
session_start();

// 👈 این قسمت رو با سیستم لاگین خودت مچ کن
// مثلاً اگر تو جای دیگه می‌نویسی $_SESSION['user']['id']، همینجا هم همونو بزن
if (empty($_SESSION['user_id'])) {
    echo json_encode([
        'ok'      => false,
        'message' => 'برای بروزرسانی اعلان‌ها باید وارد حساب شده باشی.'
    ]);
    exit;
}

$userId = (int) $_SESSION['user_id'];

// مطمئن شو $pdo داری
if (!isset($pdo) || !($pdo instanceof PDO)) {
    echo json_encode([
        'ok'      => false,
        'message' => 'اتصال به پایگاه داده برقرار نیست.'
    ]);
    exit;
}

try {
    // 👈 مطابق جدولی که دادی: notifications با ستون‌های
    // id, user_id, type, title, body, related_service_id, related_refund_id, is_read, created_at
    $stmt = $pdo->prepare("
        UPDATE notifications
        SET is_read = 1
        WHERE user_id = :uid
          AND is_read = 0
    ");
    $stmt->execute([':uid' => $userId]);

    echo json_encode([
        'ok'      => true,
        'message' => 'اعلان‌ها به عنوان خوانده شده علامت‌گذاری شدند.'
    ]);
    exit;

} catch (Throwable $e) {
    // اگر خواستی لاگ کنی:
    // error_log('notifications_mark_read error: ' . $e->getMessage());

    echo json_encode([
        'ok'      => false,
        'message' => 'خطا در بروزرسانی اعلان‌ها.'
    ]);
    exit;
}
