<?php
declare(strict_types=1);

/**
 * Insert a notification row for a user.
 *
 * Table columns:
 *  id,
 *  user_id,
 *  type,
 *  title,
 *  body,
 *  related_service_id,
 *  related_refund_id,
 *  is_read,
 *  created_at
 *
 * @param PDO    $pdo
 * @param int    $userId
 * @param string $type    e.g. 'refund_submitted', 'refund_updated', 'system'
 * @param string $title
 * @param string $body
 * @param array  $meta    e.g. ['related_service_id' => 123, 'related_refund_id' => 55]
 */
function add_notification(PDO $pdo, int $userId, string $type, string $title, string $body, array $meta = []): void
{
    $serviceId = isset($meta['related_service_id'])
        ? (int)$meta['related_service_id']
        : null;

    $refundId = isset($meta['related_refund_id'])
        ? (int)$meta['related_refund_id']
        : null;

    $sql = "
        INSERT INTO notifications (
            user_id,
            type,
            title,
            body,
            related_service_id,
            related_refund_id,
            is_read,
            created_at
        ) VALUES (
            :uid,
            :type,
            :title,
            :body,
            :svc_id,
            :refund_id,
            0,
            NOW()
        )
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':uid'       => $userId,
        ':type'      => $type,
        ':title'     => $title,
        ':body'      => $body,
        ':svc_id'    => $serviceId,
        ':refund_id' => $refundId,
    ]);
}
