<?php
// mailer.php
// PHPMailer با SSL/465 روی mail.dimob.ir + لاگ کامل
// طوری نوشته شده که اگر ایمیل ارسال نشود اسکریپت را نمی‌ترکاند (فقط لاگ می‌کند).

require_once __DIR__ . '/phpmailer/PHPMailer.php';
require_once __DIR__ . '/phpmailer/SMTP.php';
require_once __DIR__ . '/phpmailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

/**
 * ارسال ایمیل
 *
 * @param string $to       آدرس گیرنده
 * @param string $subject  عنوان
 * @param string $htmlBody بدنه HTML
 * @param string $altBody  نسخه متنی ساده
 *
 * توجه: این تابع هیچ‌وقت Exception به بیرون پرتاب نمی‌کند؛
 * در صورت خطا فقط لاگ می‌نویسد و برمی‌گردد، تا صفحه‌ی callback خراب نشود.
 */
function send_mail(string $to, string $subject, string $htmlBody, string $altBody): void
{
    // —— تنظیمات میل‌سرور (در صورت نیاز این موارد را ویرایش کن) ——
    $smtp_host  = 'mail.dimob.ir';
    $smtp_port  = 465;                    // SSL مستقیم
    $smtp_user  = 'no-reply@dimob.ir';    // یوزر ایمیل
    $smtp_pass  = 'ecvc4gix2ehea';        // پسورد ایمیل
    $from_email = 'no-reply@dimob.ir';
    $from_name  = 'دیمینت';

    // مسیر لاگ SMTP (برای عیب‌یابی)
    $logFile = __DIR__ . '/mail-debug.log';
    $log = function (string $msg) use ($logFile) {
        @file_put_contents($logFile, date('c') . ' ' . $msg . "\n", FILE_APPEND);
        @error_log($msg);
    };

    $mail = new PHPMailer(true);

    try {
        // حالت SMTP
        $mail->isSMTP();
        $mail->Host       = $smtp_host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $smtp_user;
        $mail->Password   = $smtp_pass;

        // SSL مستقیم روی 465
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // ssl
        $mail->Port       = $smtp_port;

        // تایم‌اوت‌ها (جلوگیری از هنگ طولانی)
        $mail->SMTPConnectTimeout = 8;   // ثانیه برای اتصال
        $mail->Timeout            = 15;  // ثانیه برای کل عملیات
        $mail->SMTPKeepAlive      = false;

        // دیباگ SMTP → فایل لاگ (در صورت نیاز می‌تونی 0ش کنی)
        $mail->SMTPDebug   = 2; // 0 خاموش، 2: دیباگ مفید
        $mail->Debugoutput = function ($str, $level) use ($log) {
            // ماسک کردن پسورد در لاگ
            $safe = preg_replace('/(pass(word)?\s*[:=]\s*)(.+)/i', '$1***', (string)$str);
            $log("SMTP[$level]: " . $safe);
        };

        // از IPv4 استفاده کن (بعضی هاست‌ها با IPv6 مشکل دارن)
        $mail->SMTPOptions['socket'] = ['bindto' => '0.0.0.0:0'];

        // From / Reply-To / Return-Path
        $mail->setFrom($from_email, $from_name);
        $mail->addReplyTo($from_email, $from_name);
        $mail->Sender = $from_email;

        // گیرنده
        $mail->addAddress($to);

        // محتوا
        $mail->isHTML(true);
        $mail->CharSet = 'UTF-8';
        $mail->Subject = $subject;
        $mail->Body    = $htmlBody;
        $mail->AltBody = $altBody ?: 'برای مشاهده این ایمیل لطفاً حالت HTML را فعال کنید.';

        // ارسال
        $log("SEND_START ssl-465 to=$to subj=" . mb_substr($subject, 0, 120, 'UTF-8'));
        $mail->send();
        $log("SEND_OK ssl-465 to=$to messageId=" . $mail->getLastMessageID());

    } catch (Exception $e) {
        $err = $mail->ErrorInfo ?: $e->getMessage();
        $log('MAIL_SEND_FAIL to=' . $to . ' err=' . $err);
        // عمداً Exception به بیرون پرتاب نمی‌کنیم
    } catch (\Throwable $e) {
        // هر خطای غیرمنتظره‌ی دیگر
        $log('MAIL_SEND_THROWABLE to=' . $to . ' err=' . $e->getMessage());
    }
}
