<?php
// login.php
// لاگین روی جدول users با پسورد هش‌شده
// خروجی JSON برای SPA

session_start();
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/db.php';

try {
    // سعی می‌کنیم JSON بخونیم (از fetch)
    $raw = file_get_contents('php://input');
    $data = json_decode($raw, true);

    // اگر JSON نبود، از POST معمولی بخون
    if (!is_array($data)) {
        $data = $_POST;
    }

    $email    = isset($data['email']) ? trim($data['email']) : '';
    $password = isset($data['password']) ? (string)$data['password'] : '';

    if ($email === '' || $password === '') {
        http_response_code(400);
        echo json_encode([
            'ok'      => false,
            'message' => 'ایمیل و رمز عبور را وارد کنید.',
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }

    // فقط از users می‌خوانیم (همونی که کال‌بک می‌سازه)
    $stmt = $pdo->prepare("
        SELECT id, email, site_username, site_password
        FROM users
        WHERE email = :e
        LIMIT 1
    ");
    $stmt->execute([':e' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        http_response_code(401);
        echo json_encode([
            'ok'      => false,
            'message' => 'ایمیل یا رمز عبور اشتباه است.',
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }

    // چک پسورد هش‌شده
    if (!password_verify($password, $user['site_password'])) {
        http_response_code(401);
        echo json_encode([
            'ok'      => false,
            'message' => 'ایمیل یا رمز عبور اشتباه است.',
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }

    // لاگین موفق → سشن پروژه
    $_SESSION['user_email'] = $user['email'];

    echo json_encode([
        'ok'          => true,
        'email'       => $user['email'],
        'site_username' => $user['site_username'] ?? '',
    ], JSON_UNESCAPED_UNICODE);
    exit;

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok'      => false,
        'message' => 'خطا در ورود. لطفاً بعداً دوباره امتحان کنید.',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}
