<?php
// load_env.php
// لودر ساده برای فایل .env بدون نیاز به Composer

declare(strict_types=1);

$envPath = __DIR__ . '/.env';

if (!is_file($envPath)) {
    return;
}

$lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

foreach ($lines as $line) {
    $line = trim($line);

    // رد کردن کامنت‌ها
    if ($line === '' || str_starts_with($line, '#')) {
        continue;
    }

    // جدا کردن key=value
    if (strpos($line, '=') !== false) {
        [$key, $value] = explode('=', $line, 2);
        $key   = trim($key);
        $value = trim($value);

        // حذف کوتیشن دور مقدار، اگه بود
        $value = trim($value, " \t\n\r\0\x0B\"'");

        putenv("$key=$value");
        $_ENV[$key] = $value;
        $_SERVER[$key] = $value;
    }
}
