<?php
$APP_VERSION = '2025-12-02-5';
session_start();
$isLogged = !empty($_SESSION['user_email']);
$email    = $_SESSION['user_email'] ?? null;
$popup    = $_SESSION['popup'] ?? null;
if ($popup) unset($_SESSION['popup']); // یک‌بار مصرف
?>


<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    
    <?php
// ----- Schema.org JSON-LD for plans on index page -----

$schemaPlans = [];

try {
    require_once __DIR__ . '/db.php';

    $sql = "
        SELECT
            code,
            title,
            amount_rial,
            amount_old_rial,
            imgurl,
            imgurlmob,
            plan_desc,
            is_recommended
        FROM plans
        WHERE is_active = 1
        ORDER BY amount_rial ASC, id ASC
    ";

    $stmt  = $pdo->query($sql);
    $rows  = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $schemaPlans = $rows ?: [];
} catch (Throwable $e) {
    $schemaPlans = [];
}

if (!empty($schemaPlans)) {
    $schema = [
        '@context'   => 'https://schema.org',
        '@type'      => 'WebPage',
        'name'       => 'خرید VPN پرسرعت دیمینت - پلن‌ها',
        'description'=> 'لیست پلن‌های فعال VPN دیمینت برای خرید آنلاین با سرعت بالا، پایداری و پشتیبانی کامل.',
        'url'        => 'https://example.com/', // دامین خودت رو بذار
        'mainEntity' => [
            '@type'          => 'OfferCatalog',
            'name'           => 'پلن‌های VPN دیمینت',
            'itemListElement'=> []
        ]
    ];

    foreach ($schemaPlans as $r) {
        $title   = $r['title']      ?? 'پلن VPN دیمینت';
        $desc    = $r['plan_desc']  ?? '';
        $img     = $r['imgurl']     ?? '';
        $amountRial = is_null($r['amount_rial']) ? 0 : (int)$r['amount_rial'];
        $toman      = $amountRial > 0 ? floor($amountRial / 10) : 0;

        $offer = [
            '@type' => 'Offer',
            'itemOffered' => [
                '@type'       => 'Product',
                'name'        => $title,
                'description' => $desc !== ''
                    ? $desc
                    : 'پلن VPN پرسرعت دیمینت مناسب استریم، وب‌گردی و شبکه‌های اجتماعی.',
                'category'    => 'VPN service',
            ],
            'priceCurrency' => 'IRR',
            'availability'  => 'https://schema.org/InStock',
        ];

        if (!empty($img)) {
            $offer['itemOffered']['image'] = $img;
        }

        // قیمت به تومان (همون منطقی که برای نمایش استفاده می‌کنی)
        $offer['price'] = (string) max(0, $toman);

        $schema['mainEntity']['itemListElement'][] = $offer;
    }

    echo '<script type="application/ld+json">'
        . json_encode($schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)
        . '</script>' . PHP_EOL;
}
?>

  <link rel="manifest" href="/app/manifest.webmanifest">

  <meta name="theme-color" content="#0f172a">

  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
  <meta name="apple-mobile-web-app-title" content="Diminet">

  <meta charset="UTF-8">
  <title>دیمینت | خرید و مدیریت VPN</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">

  <!-- آیکن‌ها با نسخه -->
  <link rel="icon" href="/assets/logo192.png?v=<?= urlencode($APP_VERSION) ?>">
  <link rel="apple-touch-icon" href="/assets/logo512.png?v=<?= urlencode($APP_VERSION) ?>">

  <link rel="stylesheet" href="/assets/all.min.css">
  <!-- CSS اصلی با نسخه -->
  <link rel="stylesheet" href="/app/assets/css/app.css?v=<?= urlencode($APP_VERSION) ?>">
  
  <style>
/* width */
::-webkit-scrollbar {
  width: 0.5px !important;
}

/* Track */
::-webkit-scrollbar-track {
  background: #f1f1f100 !important; 
}
 
/* Handle */
::-webkit-scrollbar-thumb {
  background: #888 !important; 
}

/* Handle on hover */
::-webkit-scrollbar-thumb:hover {
  background: #f1f1f100  !important; 
}
</style>


</head>
<body class="is-loading">

  <div id="app-root" class="app-root">
    <!-- هدر ثابت -->
    <header class="app-header">
      <div class="app-header__brand">
        <button
          class="hamburger-btn"
          id="btn-hamburger"
          type="button"
          aria-label="منوی اصلی"
        >
          <span></span>
          <span></span>
          <span></span>
        </button>

        <div class="app-header__texts">
          <div class="app-header__title">دیمینت</div>
          <div class="app-header__subtitle">خرید و مدیریت VPN</div>
        </div>
      </div>

      <div class="app-header__logo">
        <img
          src="/assets/logo.svg?v=<?= urlencode($APP_VERSION) ?>"
          alt="Diminet"
          onerror="this.src='/assets/logo.png?v=<?= urlencode($APP_VERSION) ?>'"
        >
      </div>

      <div class="app-header__actions">
        <?php if ($isLogged): ?>
          <!-- دکمه زنگوله نوتیف فقط وقتی لاگین هست -->
          <button
            id="btn-notifications"
            type="button"
            class="btn btn--ghost btn--sm header-icon-btn"
            aria-label="اعلان‌ها"
          >
            <i class="fa-regular fa-bell header-icon-btn__icon" aria-hidden="true"></i>
            <span
              id="notif-badge"
              class="header-bell-badge"
              style="display:none;"
            ></span>
          </button>
        <?php endif; ?>

        <button id="btn-theme-toggle"
          type="button"
          class="btn btn--ghost btn--sm theme-toggle-btn">
          <i class="fa-regular fa-moon theme-toggle-btn__icon" aria-hidden="true"></i>
        </button>

        <!-- دکمه ورود / خروج (متن و استایلش از app.js آپدیت می‌شود) -->
        <button id="btn-header-login" class="btn btn--ghost btn--sm">
          ورود به پنل
        </button>
      </div>
    </header>

    <!-- کانتینر اصلی ویوها -->
    <main class="app-main">
      <div id="view-container" class="view-container">
        <!-- محتوا به‌صورت داینامیک از app.js تزریق می‌شود -->
      </div>
    </main>

    <!-- ناوبری پایین (مخصوص موبایل) -->
    <nav class="app-bottom-nav">
      <!-- خانه -->
      <button class="bottom-nav-item is-active" data-route="home">
        <span class="bottom-nav-item__icon">
          <i class="fa-solid fa-house"></i>
        </span>
      </button>

      <!-- پنل / سرویس‌ها -->
      <button class="bottom-nav-item" data-route="panel">
        <span class="bottom-nav-item__icon">
          <i class="fa-solid fa-satellite-dish"></i>
        </span>
      </button>

      <!-- آموزش -->
      <button class="bottom-nav-item" data-route="help">
        <span class="bottom-nav-item__icon">
          <i class="fa-brands fa-leanpub"></i>
        </span>
      </button>
    </nav>
  </div>

  <!-- اسکریپت‌های بوت -->
  <script>
    window.__APP_BOOT__ = {
      isLogged: <?= $isLogged ? 'true' : 'false' ?>,
      email: <?= json_encode($email) ?>,
      popup: <?= json_encode($popup, JSON_UNESCAPED_UNICODE) ?>
    };

    // نسخه‌ی اپ را هم به JS پاس می‌دهیم
    window.__APP_VERSION__ = <?= json_encode($APP_VERSION) ?>;
  </script>

  <!-- اسکریپت اصلی اپ با نسخه -->
  <script src="/app/assets/js/app.js?v=<?= urlencode($APP_VERSION) ?>"></script>

  <!-- Offline / No-Connection Overlay -->
  <div id="offlineOverlay" class="offline-overlay">
    <div class="offline-overlay__box">
      <div class="offline-overlay__icon">📡</div>
      <h2 class="offline-overlay__title">اتصال اینترنت قطع شده</h2>
      <p class="offline-overlay__text">
        اتصال به سرور دیمینت برقرار نیست.
        لطفاً اینترنت خودت رو چک کن.
        به‌محض اینکه اتصال برقرار بشه، این پیام خودش بسته می‌شه.
      </p>
    </div>
  </div>

  <nav class="mobile-drawer" id="mobileDrawer">
    <div class="mobile-drawer__header">
      <span class="mobile-drawer__title">منو</span>
    </div>
    <ul class="mobile-drawer__list">
      <li><a href="/index.php?tab=home">خانه</a></li>
      <li><a href="/index.php?tab=panel">پنل کاربری</a></li>
            <li><a href="#" data-drawer-action="change-pass">تغییر رمز پنل</a></li>
          <li><a href="#" data-drawer-action="payments">پرداخت‌ها</a></li>
      <li><a href="/index.php?tab=help">آموزش اتصال</a></li>
      <li><a href="https://t.me/dimynet" target="_blank" rel="noopener">پشتیبانی تلگرام</a></li>
      <li><a href="#" data-drawer-action="telegram-bot">اتصال به ربات تلگرام</a></li>
      <li><a href="#" data-drawer-action="telegram-channel">کانال تلگرام</a></li>
    </ul>
  </nav>

  <div class="mobile-drawer-backdrop" id="mobileDrawerBackdrop"></div>

</body>
</html>
