<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>راهنمای اتصال دیمینت - مینیمال</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
  />

  <style>
    :root {
      --bg: #020617;
      --card-bg: #02081b;
      --accent: #22c55e;
      --accent-soft: rgba(34, 197, 94, 0.1);
      --border: #1f2937;
      --text: #e5e7eb;
      --text-soft: #9ca3af;
      --radius: 14px;
    }

    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      min-height: 100vh;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Vazir", "IRANSans", sans-serif;
      background: var(--bg);
      color: var(--text);
      display: flex;
      justify-content: center;
      padding: 16px;
    }

    .help {
      width: 100%;
      max-width: 840px;
      background: var(--card-bg);
      border-radius: 18px;
      border: 1px solid var(--border);
      padding: 16px 16px 18px;
    }

    /* HEADER */
    .help__header {
      display: flex;
      flex-direction: column;
      gap: 6px;
      margin-bottom: 14px;
    }

    .help__title-row {
      display: flex;
      align-items: center;
      justify-content: space-between;
      gap: 10px;
      flex-wrap: wrap;
    }

    .help__title-main {
      display: flex;
      align-items: center;
      gap: 10px;
      flex-wrap: wrap;
    }

    .help__icon {
      width: 30px;
      height: 30px;
      border-radius: 999px;
      border: 1px solid var(--accent);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      font-size: 14px;
      color: var(--accent);
    }

    .help__title-text {
      display: flex;
      flex-direction: column;
      gap: 2px;
    }

    .help__title {
      font-size: 15px;
      font-weight: 700;
    }

    .help__subtitle {
      font-size: 11px;
      color: var(--text-soft);
      line-height: 1.7;
    }

    .help__subtitle b {
      color: var(--text);
      font-weight: 600;
    }

    .help__badge {
      font-size: 10px;
      padding: 3px 8px;
      border-radius: 999px;
      border: 1px solid var(--accent);
      color: var(--accent);
      display: inline-flex;
      align-items: center;
      gap: 4px;
    }

    .help__badge i {
      font-size: 10px;
    }

    /* PRECHECK */
    .help__precheck {
      margin-bottom: 14px;
    }

    .precheck {
      background: #020617;
      border-radius: var(--radius);
      border: 1px solid var(--border);
      padding: 8px 10px;
      font-size: 11px;
      color: var(--text-soft);
    }

    .precheck__header {
      display: flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 4px;
      color: var(--text);
      font-size: 11px;
      font-weight: 600;
    }

    .precheck__header i {
      color: #facc15;
      font-size: 12px;
    }

    .precheck ul {
      margin: 0;
      padding-right: 16px;
    }

    .precheck li {
      margin-bottom: 2px;
    }

    /* PLATFORM SELECTOR */
    .help__platforms {
      margin-bottom: 12px;
    }

    .platforms__label {
      font-size: 11px;
      color: var(--text-soft);
      margin-bottom: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
    }

    .platforms__label i {
      font-size: 12px;
      color: var(--accent);
    }

    .platforms__list {
      display: grid;
      grid-template-columns: repeat(3, minmax(0, 1fr));
      gap: 8px;
    }

    .platform {
      border-radius: 999px;
      border: 1px solid var(--border);
      background: #020617;
      padding: 6px 10px;
      font-size: 11px;
      color: var(--text-soft);
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 6px;
      cursor: pointer;
      transition: background 0.15s ease-out, border-color 0.15s ease-out, color 0.15s;
    }

    .platform i {
      font-size: 13px;
    }

    .platform--active {
      border-color: var(--accent);
      background: var(--accent-soft);
      color: var(--text);
    }

    /* PANELS */
    .help__panels {
      border-radius: var(--radius);
      border: 1px solid var(--border);
      background: #020617;
      padding: 10px 10px 12px;
    }

    .panel {
      display: none;
    }

    .panel--active {
      display: block;
    }

    .panel__header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      gap: 8px;
      flex-wrap: wrap;
      margin-bottom: 8px;
    }

    .panel__title {
      display: flex;
      align-items: center;
      gap: 6px;
      font-size: 13px;
      font-weight: 600;
    }

    .panel__title i {
      color: var(--accent);
      font-size: 15px;
    }

    .panel__hint {
      font-size: 10px;
      color: var(--text-soft);
      display: flex;
      align-items: center;
      gap: 4px;
    }

    .panel__hint i {
      font-size: 11px;
      color: #facc15;
    }

    .panel__chips {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      margin-bottom: 6px;
    }

    .panel__chip {
      font-size: 10px;
      padding: 2px 7px;
      border-radius: 999px;
      border: 1px solid var(--border);
      color: var(--text-soft);
      display: inline-flex;
      align-items: center;
      gap: 4px;
    }

    .panel__chip i {
      font-size: 10px;
    }

    /* STEPS */
    .steps {
      list-style: none;
      margin: 0;
      padding: 0;
      display: flex;
      flex-direction: column;
      gap: 6px;
      font-size: 11px;
    }

    .step {
      display: grid;
      grid-template-columns: auto 1fr;
      gap: 4px 8px;
      align-items: flex-start;
      padding: 7px 8px;
      border-radius: 10px;
      border: 1px solid var(--border);
      background: #02081b;
    }

    .step__index {
      width: 22px;
      height: 22px;
      border-radius: 999px;
      border: 1px solid var(--border);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      font-size: 11px;
      color: var(--text-soft);
    }

    .step__body {
      display: flex;
      flex-direction: column;
      gap: 2px;
    }

    .step__title {
      font-size: 11px;
      font-weight: 600;
      color: var(--text);
    }

    .step__text {
      font-size: 11px;
      color: var(--text-soft);
      line-height: 1.7;
    }

    .step__text b {
      color: var(--text);
      font-weight: 600;
    }

    .step__note {
      font-size: 10px;
      color: #facc15;
      display: flex;
      align-items: center;
      gap: 4px;
      margin-top: 1px;
    }

    .step__note i {
      font-size: 11px;
    }

    .panel__footer {
      margin-top: 8px;
      padding-top: 6px;
      border-top: 1px dashed var(--border);
      font-size: 10px;
      color: var(--text-soft);
      display: flex;
      gap: 6px;
    }

    .panel__footer i {
      margin-top: 1px;
      font-size: 11px;
    }

    /* RESPONSIVE */
    @media (max-width: 640px) {
      .help {
        padding: 12px;
        border-radius: 14px;
      }
      .platforms__list {
        grid-template-columns: repeat(3, minmax(0, 1fr));
      }
    }

    @media (max-width: 480px) {
      .panel__header {
        flex-direction: column;
        align-items: flex-start;
      }
    }
  </style>
</head>
<body>

  <main class="help">
    <!-- HEADER -->
    <header class="help__header">
      <div class="help__title-row">
        <div class="help__title-main">
          <div class="help__icon">
            <i class="fa-solid fa-wifi"></i>
          </div>
          <div class="help__title-text">
            <div class="help__title">چطور به دیمینت وصل بشم؟</div>
            <p class="help__subtitle">
              فقط سه کار لازم است: <b>برنامه را نصب کن</b>،
              <b>لینک اشتراک را از پنل کپی کن</b>،
              <b>داخل برنامه Paste و Connect</b>.
            </p>
          </div>
        </div>
        <span class="help__badge">
          <i class="fa-solid fa-user"></i>
          مناسب کاربر مبتدی
        </span>
      </div>
    </header>

    <!-- PRECHECK -->
    <section class="help__precheck">
      <div class="precheck">
        <div class="precheck__header">
          <i class="fa-solid fa-triangle-exclamation"></i>
          <span>قبل از شروع این سه مورد را چک کن:</span>
        </div>
        <ul>
          <li>اینترنتت فعال و حجمت تمام نشده باشد.</li>
          <li>هر فیلترشکن دیگری روشن است، کامل ببند.</li>
          <li>ساعت و تاریخ گوشی روی حالت خودکار باشد.</li>
        </ul>
      </div>
    </section>

    <!-- PLATFORM SELECT -->
    <section class="help__platforms">
      <div class="platforms__label">
        <i class="fa-solid fa-mobile-screen-button"></i>
        <span>دستگاهی که با آن وصل می‌شوی را انتخاب کن:</span>
      </div>
      <div class="platforms__list" id="platformList">
        <button type="button" class="platform platform--active" data-platform="android">
          <i class="fa-brands fa-android"></i>
          <span>اندروید</span>
        </button>
        <button type="button" class="platform" data-platform="ios">
          <i class="fa-brands fa-apple"></i>
          <span>آیفون</span>
        </button>
        <button type="button" class="platform" data-platform="windows">
          <i class="fa-brands fa-windows"></i>
          <span>ویندوز</span>
        </button>
      </div>
    </section>

    <!-- PANELS -->
    <section class="help__panels">
      <!-- ANDROID -->
      <div class="panel panel--active" data-panel="android">
        <div class="panel__header">
          <div class="panel__title">
            <i class="fa-brands fa-android"></i>
            <span>آموزش اتصال اندروید (v2rayNG)</span>
          </div>
          <div class="panel__hint">
            <i class="fa-solid fa-circle-info"></i>
            <span>اپ v2rayNG را می‌توانی از گوگل‌پلی یا لینک داخل پنل بگیری.</span>
          </div>
        </div>

        <div class="panel__chips">
          <span class="panel__chip">
            <i class="fa-solid fa-download"></i>
            اپ پیشنهادی: v2rayNG
          </span>
          <span class="panel__chip">
            <i class="fa-solid fa-link"></i>
            لینک اشتراک را از پنل کپی کن
          </span>
        </div>

        <ol class="steps">
          <li class="step">
            <div class="step__index">۱</div>
            <div class="step__body">
              <div class="step__title">نصب و باز کردن v2rayNG</div>
              <p class="step__text">
                v2rayNG را نصب و اجرا کن. اگر از لینک داخل پنل نصب می‌کنی، نسخه مخصوص ایران است.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۲</div>
            <div class="step__body">
              <div class="step__title">کپی لینک اشتراک از پنل دیمینت</div>
              <p class="step__text">
                وارد پنل دیمینت شو، روی سرویس خودت بزن و <b>لینک اشتراک (Sub)</b> را کامل کپی کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۳</div>
            <div class="step__body">
              <div class="step__title">وارد کردن لینک در v2rayNG</div>
              <p class="step__text">
                در v2rayNG روی علامت <b>+</b> بزن و گزینه
                <b>Import from clipboard</b> یا <b>Subscription</b> را بزن تا لینکت اضافه شود.
              </p>
              <div class="step__note">
                <i class="fa-solid fa-lightbulb"></i>
                اگر خطا داد، لینک را دوباره از پنل کپی کن (بدون فاصله اضافه).
              </div>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۴</div>
            <div class="step__body">
              <div class="step__title">آپدیت و انتخاب سرور</div>
              <p class="step__text">
                گزینه <b>Update subscription</b> را بزن تا لیست سرورها بیاید؛ یکی از سرورهای دیمینت را انتخاب کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۵</div>
            <div class="step__body">
              <div class="step__title">اتصال</div>
              <p class="step__text">
                روی دکمه <b>Connect</b> بزن. اگر اندروید اجازه VPN خواست، روی <b>Allow / اجازه</b> بزن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۶</div>
            <div class="step__body">
              <div class="step__title">کندی یا مشکل؟</div>
              <p class="step__text">
                فقط از همان لیست یک سرور دیگر انتخاب کن و دوباره Connect بزن؛ نیاز به انجام مراحل از اول نیست.
              </p>
            </div>
          </li>
        </ol>

        <div class="panel__footer">
          <i class="fa-solid fa-headset"></i>
          <div>
            اگر با همه این مراحل باز هم وصل نشدی، یک اسکرین از v2rayNG بگیر و از داخل پنل روی
            «پشتیبانی» بزن تا در تلگرام دقیق راهنمایی‌ات کنیم.
          </div>
        </div>
      </div>

      <!-- IOS -->
      <div class="panel" data-panel="ios">
        <div class="panel__header">
          <div class="panel__title">
            <i class="fa-brands fa-apple"></i>
            <span>آموزش اتصال آیفون (Shadowrocket / ...)</span>
          </div>
          <div class="panel__hint">
            <i class="fa-solid fa-circle-info"></i>
            <span>لینک اشتراک را فقط یک‌بار اضافه می‌کنی؛ بعدش فقط سرور عوض می‌کنی.</span>
          </div>
        </div>

        <div class="panel__chips">
          <span class="panel__chip">
            <i class="fa-solid fa-download"></i>
            اپ پیشنهادی: Shadowrocket
          </span>
        </div>

        <ol class="steps">
          <li class="step">
            <div class="step__index">۱</div>
            <div class="step__body">
              <div class="step__title">نصب اپ روی آیفون</div>
              <p class="step__text">
                یکی از اپ‌ها مثل <b>Shadowrocket</b> را نصب و اجرا کن. ترجیحاً آخرین نسخه باشد.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۲</div>
            <div class="step__body">
              <div class="step__title">اضافه کردن لینک اشتراک</div>
              <p class="step__text">
                در اپ، بخش <b>Subscription</b> یا <b>+</b> را بزن، لینک اشتراک دیمینت را Paste و Save کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۳</div>
            <div class="step__body">
              <div class="step__title">آپدیت و Connect</div>
              <p class="step__text">
                لیست را Update کن، یک سرور انتخاب کن و دکمه <b>Connect</b> را فعال کن. اگر iOS اجازه VPN خواست، تأیید کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۴</div>
            <div class="step__body">
              <div class="step__title">در زمان شلوغی</div>
              <p class="step__text">
                اگر سرعت کم شد، فقط از لیست، سرور دیگری انتخاب کن و دوباره Connect را بزن.
              </p>
            </div>
          </li>
        </ol>

        <div class="panel__footer">
          <i class="fa-solid fa-headset"></i>
          <div>
            اگر مشکل داشتی، اسکرین از صفحه سرورها و تنظیمات VPN بگیر و برای پشتیبانی بفرست تا چک کنیم.
          </div>
        </div>
      </div>

      <!-- WINDOWS -->
      <div class="panel" data-panel="windows">
        <div class="panel__header">
          <div class="panel__title">
            <i class="fa-brands fa-windows"></i>
            <span>آموزش اتصال ویندوز (Clash / Nekoray)</span>
          </div>
          <div class="panel__hint">
            <i class="fa-solid fa-circle-info"></i>
            <span>برای مرورگرها معمولاً باید System Proxy روشن باشد.</span>
          </div>
        </div>

        <div class="panel__chips">
          <span class="panel__chip">
            <i class="fa-solid fa-download"></i>
            برنامه پیشنهادی: Clash / Nekoray
          </span>
        </div>

        <ol class="steps">
          <li class="step">
            <div class="step__index">۱</div>
            <div class="step__body">
              <div class="step__title">نصب برنامه روی ویندوز</div>
              <p class="step__text">
                Clash یا Nekoray را از لینک مطمئن (یا لینکی که در پنل گذاشتیم) نصب و اجرا کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۲</div>
            <div class="step__body">
              <div class="step__title">وارد کردن لینک اشتراک</div>
              <p class="step__text">
                در بخش Subscription یا Import from URL، لینک اشتراک دیمینت را Paste و ذخیره کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۳</div>
            <div class="step__body">
              <div class="step__title">انتخاب پروفایل و اتصال</div>
              <p class="step__text">
                لیست را به‌روز کن، یکی از پروفایل‌های دیمینت را انتخاب کن و روی Start / Connect کلیک کن.
              </p>
            </div>
          </li>

          <li class="step">
            <div class="step__index">۴</div>
            <div class="step__body">
              <div class="step__title">برای مرورگرها</div>
              <p class="step__text">
                اگر از Clash استفاده می‌کنی، گزینه <b>System Proxy</b> را حتماً روشن کن تا ترافیک از VPN عبور کند.
              </p>
            </div>
          </li>
        </ol>

        <div class="panel__footer">
          <i class="fa-solid fa-exclamation-circle"></i>
          <div>
            اگر بعضی سایت‌ها همچنان بدون VPN باز می‌شوند، مرورگر را کامل ببند و باز کن و وضعیت System Proxy را چک کن.
          </div>
        </div>
      </div>
    </section>
  </main>

  <script>
    (function () {
      const platformBtns = document.querySelectorAll(".platform");
      const panels = document.querySelectorAll(".panel");

      platformBtns.forEach((btn) => {
        btn.addEventListener("click", () => {
          const key = btn.getAttribute("data-platform");
          if (!key) return;

          platformBtns.forEach(b => b.classList.remove("platform--active"));
          panels.forEach(p => p.classList.remove("panel--active"));

          btn.classList.add("platform--active");
          const panel = document.querySelector('[data-panel="' + key + '"]');
          if (panel) panel.classList.add("panel--active");
        });
      });
    })();
  </script>
</body>
</html>
