<?php
// forgot.php
// کاربر ایمیلش رو می‌دهد و ما لینک ریست می‌فرستیم (اگر یوزر وجود داشته باشه)

session_start();
require __DIR__ . '/db.php';
require __DIR__ . '/mailer.php';

// helper: ساخت توکن رندوم امن
function gen_token(int $len = 32): string {
    return bin2hex(random_bytes($len)); // طول نهایی میشه 64 کاراکتر هگز
}

// helper: ولیدیشن ساده ایمیل
function is_valid_email($email){
    return (bool)preg_match('/^[^\s@]+@[^\s@]+\.[^\s@]+$/', $email);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');

    // پیام واحد برای امنیت (چه کاربر باشه چه نباشه)
    $genericMsg = "اگر ایمیل وارد‌شده در سیستم ما وجود داشته باشد، یک لینک برای تغییر رمز ارسال خواهد شد.";

    // اگر خالیه یا فرمت ایمیل غلطه => اصلاً ادامه نده و ایمیل هم نفرست
    if ($email === '' || !is_valid_email($email)) {
        $notice = "لطفاً ایمیل معتبر وارد کنید.";
    } else {
        // ببین کاربر تو users هست یا نه
        $stmt = $pdo->prepare("SELECT id, email FROM users WHERE email = :e LIMIT 1");
        $stmt->execute([':e' => $email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            // ساخت توکن و ذخیره در password_resets
            $token = gen_token(16); // 32 کاراکتر هگز
            $expiresAt = date('Y-m-d H:i:s', time() + 1800); // +30 دقیقه

            // پاک کردن توکن‌های قبلی این ایمیل
            $pdo->prepare("DELETE FROM password_resets WHERE email = :e")
                ->execute([':e' => $email]);

            $pdo->prepare("
                INSERT INTO password_resets (email, token, expires_at)
                VALUES (:email, :token, :exp)
            ")->execute([
                ':email' => $email,
                ':token' => $token,
                ':exp'   => $expiresAt,
            ]);

            // لینک ریست
            $resetLink = "https://ts.dimob.ir/reset.php?token=" . urlencode($token);

            // ایمیل
            $subject  = "درخواست تغییر رمز عبور - دیمینت";
            $htmlBody = "
                <div style='font-family:Tahoma,Verdana,sans-serif;direction:rtl;text-align:right;line-height:1.8;color:#0f172a'>
                    <h2 style='margin:0 0 10px;font-weight:800;font-size:16px'>تغییر رمز عبور</h2>
                    <p style='margin:0 0 12px;font-size:14px'>
                        برای انتخاب رمز جدید، روی دکمه زیر بزنید. این لینک فقط تا ۳۰ دقیقه معتبر است.
                    </p>
                    <p style='margin:0 0 16px;font-size:14px'>
                        اگر شما این درخواست را ارسال نکرده‌اید، این ایمیل را نادیده بگیرید.
                    </p>
                    <p style='text-align:center;margin-top:24px'>
                        <a href='$resetLink'
                           style=\"display:inline-block;background:#2563eb;color:#fff;text-decoration:none;
                                  padding:10px 16px;border-radius:10px;font-weight:700;font-size:14px\">
                            تغییر رمز
                        </a>
                    </p>
                    <p style='margin-top:24px;font-size:12px;color:#6b7280;word-break:break-all;line-height:1.6'>
                        اگر دکمه بالا کار نکرد این لینک را در مرورگر باز کنید:<br>
                        <span style='direction:ltr;display:inline-block;color:#0f172a;font-family:monospace'>
                            $resetLink
                        </span>
                    </p>
                </div>
            ";
            $altBody = "برای تغییر رمز عبور روی لینک زیر بروید (۳۰ دقیقه اعتبار دارد):\n\n$resetLink\n\nاگر شما این درخواست را نفرستادید، این ایمیل را نادیده بگیرید.";

            send_mail($email, $subject, $htmlBody, $altBody);
        }

        $notice = $genericMsg;
    }
} else {
    $notice = '';
}
// بلافاصله بعد از محاسبه $notice و قبل از HTML:
if (($_POST['ajax'] ?? '') === '1') {
    header('Content-Type: application/json; charset=utf-8');
    // اگر ایمیل غلط بود:
    if ($notice === "لطفاً ایمیل معتبر وارد کنید.") {
        echo json_encode([
            'ok' => false,
            'message' => $notice,
        ]);
    } else {
        // پیام امن مشترک
        echo json_encode([
            'ok' => true,
            'message' => $genericMsg,
        ]);
    }
    exit;
}

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta name="robots" content="noindex, nofollow">
    <link rel="canonical" href="https://dim.dimob.ir/forgot.php">

  <meta charset="UTF-8" />
  <title>فراموشی رمز | دیمینت</title>
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

  <style>
    /* ===== فونت Vazirmatn با وزن‌ها ===== */
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-Thin.woff2') format('woff2');
      font-weight: 100;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-ExtraLight.woff2') format('woff2');
      font-weight: 200;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-Light.woff2') format('woff2');
      font-weight: 300;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');
      font-weight: 400;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-Medium.woff2') format('woff2');
      font-weight: 500;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-SemiBold.woff2') format('woff2');
      font-weight: 600;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-Bold.woff2') format('woff2');
      font-weight: 700;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-ExtraBold.woff2') format('woff2');
      font-weight: 800;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: Vazirmatn;
      src: url('/assets/fonts/webfonts/Vazirmatn-Black.woff2') format('woff2');
      font-weight: 900;
      font-style: normal;
      font-display: swap;
    }

    :root{
      --bg: #f5f7fb;
      --card: #ffffff;
      --muted: #6b7280;
      --text: #0f172a;
      --primary: #2563eb;
      --primary-600: #1d4ed8;
      --line: #e5e7eb;
      --line-soft:#f1f5f9;
      --danger:#ef4444;
      --ok:#16a34a;
      --radius-card:16px;

      --success-bg:#ecfdf5;
      --success-border:#6ee7b7;
      --success-text:#065f46;
    }

    *{
      box-sizing:border-box;
      font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial, "Noto Sans", "Liberation Sans", sans-serif;
    }

    html, body{
      margin:0;
      padding:0;
      background:var(--bg);
      color:var(--text);
      min-height:100vh;
    }

    /* پس‌زمینه متحرک دسکتاپ */
    @media(min-width:1024px){
      body{
        position: relative;
        background: transparent;
      }
      body::before{
        content:"";
        position:fixed;
        inset:0;
        z-index:-1;
        background:
          radial-gradient(circle at 20% 30%, rgba(37,99,235,.22) 0%, rgba(255,255,255,0) 60%),
          radial-gradient(circle at 80% 20%, rgba(16,185,129,.18) 0%, rgba(255,255,255,0) 60%),
          radial-gradient(circle at 50% 80%, rgba(168,85,247,.16) 0%, rgba(255,255,255,0) 60%),
          linear-gradient(115deg, #f8fafc 0%, #eef2ff 50%, #f9fafb 100%);
        background-size: 140% 140%;
        animation: bgFloat 3s ease-in-out infinite;
      }
    }
    @keyframes bgFloat {
      0%   { background-position: 0% 0%;   }
      50%  { background-position: 100% 80%; }
      100% { background-position: 0% 0%;   }
    }

    /* صفحه بیرونی و کارت - همیشه وسط صفحه، حتی دسکتاپ */
    .page{
      max-width: 1000px;
      margin: 0 auto;
      padding: 24px 16px;
      min-height:100vh;

      display:flex;
      align-items:center;
      justify-content:center;
    }

    .card{
      background:var(--card);
      border:1px solid var(--line);
      border-radius:var(--radius-card);
      box-shadow: 0 10px 25px rgba(2,6,23,.06);
      overflow:hidden;
      position:relative;
      width:100%;
      max-width:480px;
    }

    @media(min-width:1024px){
      .card{
        background: radial-gradient(circle at 50% 0%, rgba(255,255,255,1) 0%, rgba(248,250,252,1) 70%);
        border:1px solid rgba(148,163,184,.25);
        box-shadow:
          0 40px 80px rgba(15,23,42,.18),
          0 4px 16px rgba(0,0,0,.05);
        backdrop-filter: blur(3px);
        max-width:480px;
        margin-top:0;
      }
    }

    /* ====== Header داخل کارت ====== */
    .card-head{
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:16px;
      padding:16px 20px 14px;
      background:var(--card);
      border-bottom:1px solid var(--line-soft);
      flex-wrap:nowrap;
    }
    @media(min-width:1024px){
      .card-head{
        padding:20px 24px 16px;
        border-bottom:1px solid rgba(148,163,184,.18);
        background:linear-gradient(to bottom right, rgba(255,255,255,.9) 0%, rgba(248,250,252,.8) 100%);
      }
    }

    .brand-block{
      display:flex;
      align-items:center;
      gap:12px;
      min-width:0;
    }

    .brand-logo{
      width:44px;
      height:44px;
      border-radius:12px;
      background:#fff;
      border:1px solid var(--line);
      box-shadow:0 8px 20px rgba(0,0,0,.04);
      display:flex;
      align-items:center;
      justify-content:center;
      overflow:hidden;
      flex-shrink:0;
    }
    .brand-logo img{
      width:100%;
      height:100%;
      object-fit:contain;
      display:block;
    }

    @media(min-width:1024px){
      .brand-logo{
        box-shadow:0 16px 32px rgba(37,99,235,.18);
        border:1px solid rgba(37,99,235,.3);
        background:radial-gradient(circle at 30% 30%, #fff 0%, #e0e7ff 60%);
      }
    }

    .brand-texts{
      display:flex;
      flex-direction:column;
      line-height:1.3;
    }
    .brand-name{
      font-size:16px;
      font-weight:800;
      color:var(--text);
      text-decoration:none;
    }
    .brand-sub-desktop{
      font-size:12px;
      font-weight:600;
      color:var(--muted);
      line-height:1.4;
      display:block;
      text-align:right;
    }
    .brand-sub-mobile{
      font-size:12px;
      font-weight:600;
      color:var(--muted);
      line-height:1.4;
      display:none;
      text-align:right;
    }

    .head-actions{
      display:flex;
      align-items:center;
      gap:8px;
      flex-wrap:nowrap;
      flex-shrink:0;
    }

    .head-btn{
      display:inline-flex;
      align-items:center;
      justify-content:center;
      gap:6px;
      min-height:34px;
      border-radius:10px;
      font-weight:700;
      font-size:13px;
      line-height:1.2;
      text-decoration:none;
      padding:8px 12px;
      transition:all .12s ease;
      box-shadow:0 8px 20px rgba(0,0,0,.06);
      border:2px solid transparent;
      color:#fff;
      white-space:nowrap;
    }

    .btn-telegram{
      background:#229ED9;
      border-color:#229ED9;
    }
    .btn-telegram:hover{
      transform: translateY(-2px) scale(1.03);
      box-shadow:0 12px 24px rgba(34,158,217,.4);
    }
    .btn-telegram svg{
      width:16px;
      height:16px;
      fill:#fff;
    }

    @media(min-width:1024px){
      .head-btn{
        border-radius:12px;
        min-height:40px;
        font-size:13px;
        padding:9px 14px;
        box-shadow:0 16px 32px rgba(15,23,42,.22);
      }
      .btn-telegram{
        background:linear-gradient(to bottom right,#2aa7e2 0%,#1b7fb4 60%);
        border-color:rgba(34,158,217,.6);
      }
    }

    .text-full{ display:inline; }
    .text-short{ display:none; }

    @media(max-width:500px){
      .card-head{
        flex-wrap:nowrap;
        flex-direction:row;
        align-items:center;
        justify-content:space-between;
        padding:12px 14px;
        border-bottom:1px solid var(--line);
        background:#fff;
      }
      .brand-block{ gap:10px; }
      .brand-logo{
        width:40px;
        height:40px;
        border-radius:10px;
      }
      .brand-name{
        font-size:14px;
      }
      .brand-sub-desktop{ display:none; }
      .brand-sub-mobile{ display:block; }

      .head-actions{ gap:6px; }
      .head-btn{
        min-height:32px;
        font-size:12px;
        padding:7px 10px;
        border-radius:8px;
        box-shadow:0 6px 14px rgba(0,0,0,.15);
      }
      .text-full{ display:none; }
      .text-short{ display:inline; }
    }

    /* ===== بدنه کارت (فراموشی رمز) ===== */
    .card-body{
      padding:20px;
    }

    .login-head{
      text-align:right;
      margin-bottom:20px;
    }
    .login-title{
      font-size:18px;
      font-weight:900;
      margin:0 0 6px;
      color:var(--text);
      line-height:1.4;
      display:flex;
      align-items:flex-start;
      flex-wrap:wrap;
      gap:10px;
    }

    .login-sub{
      font-size:13px;
      font-weight:600;
      color:var(--muted);
      line-height:1.6;
      margin:0;
    }

    .form-forgot{
      display:flex;
      flex-direction:column;
      gap:12px;
      margin-bottom:16px;
    }
    .field-block{
      display:flex;
      flex-direction:column;
      gap:6px;
    }
    .field-label{
      font-size:13px;
      font-weight:700;
      color:#0f172a;
      line-height:1.5;
      text-align:right;
    }

    .input{
      width:100%;
      padding:12px 14px;
      border:2px solid var(--line);
      border-radius:10px;
      font-size:15px;
      background:#fff;
      color:#0f172a;
      outline:none;
      direction:ltr;
      text-align:left;
      font-weight:500;
      box-shadow:0 4px 10px rgba(0,0,0,.03);
      transition:border .2s ease, box-shadow .2s ease;
    }
    .input::placeholder {
      direction:rtl;
      text-align:right;
      color:#888;
    }
    .input:focus{
      border-color: var(--primary);
      box-shadow: 0 0 0 3px rgba(37,99,235,.12);
    }

    .actions{
      display:flex;
      align-items:flex-end;
      justify-content:center;
    }
    .btn-submit{
      background:var(--primary);
      color:#fff;
      border:none;
      border-radius:10px;
      padding:12px 18px;
      font-size:16px;
      font-weight:800;
      cursor:pointer;
      transition: background .2s ease, transform .08s ease;
      width:100%;
      max-width:220px;
      box-shadow:0 10px 24px rgba(37,99,235,.25);
      font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
      text-align:center;
    }
    .btn-submit:hover{
      background:var(--primary-600);
      transform: translateY(-1px) scale(1.02);
      box-shadow:0 16px 32px rgba(29,78,216,.4);
    }

    .notice{
      background:var(--success-bg);
      border:1px solid var(--success-border);
      border-radius:10px;
      color:var(--success-text);
      font-size:.9rem;
      font-weight:600;
      line-height:1.6;
      padding:12px;
      margin-top:16px;
      text-align:center;
      word-break:break-word;
    }

    .back-login{
      text-align:center;
      margin-top:20px;
      font-size:.9rem;
      font-weight:600;
      line-height:1.6;
    }
    .back-login a{
      color:var(--primary);
      text-decoration:none;
      font-weight:800;
    }
    .back-login a:hover{
      text-decoration:underline;
    }

    input, button {
      font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif !important;
    }
    ::placeholder {
      font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
    }
  </style>
</head>
<body>

  <div class="page">
    <div class="card">

      <!-- هدر کارت -->
      <div class="card-head">
        <div class="brand-block">
          <div class="brand-logo">
            <img src="/assets/logo.svg" alt="Diminet" onerror="this.src='/assets/logo.png'">
          </div>
          <div class="brand-texts">
            <a class="brand-name" href="https://diminet.ir" target="_blank" rel="noopener">دیمینت</a>
            <div class="brand-sub-desktop">اینترنت آزاد</div>
            <div class="brand-sub-mobile">VPN</div>
          </div>
        </div>

        <div class="head-actions">
          <a class="head-btn btn-telegram" href="https://t.me/dimobybot" target="_blank" rel="noopener">
            <svg viewBox="0 0 24 24" aria-hidden="true">
              <path d="M9.036 15.803l-.376 5.3c.538 0 .771-.231 1.049-.508l2.518-2.414 5.215 3.812c.956.528 1.637.251 1.896-.885l3.438-16.12.001-.001c.305-1.422-.513-1.978-1.432-1.63L1.7 9.63c-1.39.539-1.37 1.316-.237 1.668l5.397 1.68L18.718 6.4c.626-.413 1.197-.183.727.23"/>
            </svg>
            <span class="text-full">ربات فروش تلگرام</span>
            <span class="text-short">ربات</span>
          </a>
        </div>
      </div>
      <!-- /card-head -->

      <!-- بدنه فرم فراموشی رمز -->
      <div class="card-body">

        <div class="login-head">
          <div class="login-title">
            <span>فراموشی رمز عبور</span>
          </div>
          <p class="login-sub">
            ایمیلی که باهاش اکانت خریدی رو وارد کن. اگر وجود داشته باشه لینک تغییر رمز برات میاد ✉️
          </p>
        </div>

        <form class="form-forgot" method="post" autocomplete="off" novalidate>
          <div class="field-block">
            <label class="field-label" for="email"></label>
            <input class="input" id="email" name="email" type="email" required placeholder="ایمیل">
          </div>

          <div class="actions">
            <button class="btn-submit" type="submit">ارسال لینک بازیابی</button>
          </div>
        </form>

        <?php if ($notice !== ''): ?>
          <div class="notice"><?= htmlspecialchars($notice) ?></div>
        <?php endif; ?>

        <div class="back-login">
          <a href="/index.php">بازگشت به صفحه ورود</a>
        </div>

      </div><!-- /card-body -->

    </div><!-- /card -->
  </div><!-- /page -->

</body>
</html>

