<?php
// change_password.php
session_start();
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'message' => 'روش دسترسی نامعتبر است.']);
    exit;
}

if (empty($_SESSION['user_email'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'message' => 'ابتدا وارد شوید.']);
    exit;
}

require __DIR__ . '/db.php';

// ورودی JSON
$input = json_decode(file_get_contents('php://input'), true);
$newPass = trim($input['new_password'] ?? '');

if (mb_strlen($newPass) < 6) {
    echo json_encode(['ok' => false, 'message' => 'رمز جدید باید حداقل ۶ کاراکتر باشد.']);
    exit;
}

try {
    $email = $_SESSION['user_email'];

    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :e LIMIT 1");
    $stmt->execute([':e' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        http_response_code(404);
        echo json_encode(['ok' => false, 'message' => 'کاربر یافت نشد.']);
        exit;
    }

    $hash = password_hash($newPass, PASSWORD_DEFAULT);
    $up = $pdo->prepare("UPDATE users SET site_password = :p WHERE id = :id LIMIT 1");
    $up->execute([
        ':p'  => $hash,
        ':id' => $user['id'],
    ]);

    echo json_encode(['ok' => true, 'message' => 'رمز عبور با موفقیت تغییر کرد.']);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'message' => 'خطا در تغییر رمز.']);
}
