<?php
// پروژه دیمینت

// callback.php
// تأیید پرداخت زرین‌پال + ساخت/تمدید سرویس چندپنلی (Marzban / X-UI) + کیف پول + ایمیل

session_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/db.php';
require __DIR__ . '/settings.php';
require __DIR__ . '/marzban.php';
require __DIR__ . '/mailer.php';
require __DIR__ . '/wallet_lib.php';

/* ------------------------------------------------------------------
 *  صفحه خطا (همون تم قبلی خودت)
 * ------------------------------------------------------------------ */
 
 
 function build_xui_subscription_full(string $panelBaseUrl, string $subId): string
{
    $subId = trim($subId);
    if ($subId === '') {
        return '';
    }

    $panelBaseUrl = trim($panelBaseUrl);
    if ($panelBaseUrl === '') {
        return '';
    }

    $u = parse_url($panelBaseUrl);
    if ($u === false || empty($u['host'])) {
        return '';
    }

    $scheme = $u['scheme'] ?? 'https';
    $host   = $u['host'];

    // الگو: panel-domain + :5050/subs/ + token
    return $scheme . '://' . $host . ':5050/subs/' . $subId;
}

function render_error_page($title, $message, $refId = '', $email = '', $site_user = '', $site_pass = '')
{
  ?>
  <!DOCTYPE html>
  <html lang="fa" dir="rtl">
  <head>
      <meta name="robots" content="noindex, nofollow">
      <link rel="canonical" href="https://dim.dimob.ir/callback.php">
      <meta charset="UTF-8">
      <title><?= htmlspecialchars($title) ?> | دیمینت</title>
      <meta name="viewport" content="width=device-width,initial-scale=1" />
      <style>
        /* ========= فونت ========= */
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-Thin.woff2') format('woff2');
          font-weight: 100;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-ExtraLight.woff2') format('woff2');
          font-weight: 200;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-Light.woff2') format('woff2');
          font-weight: 300;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');
          font-weight: 400;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-Medium.woff2') format('woff2');
          font-weight: 500;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-SemiBold.woff2') format('woff2');
          font-weight: 600;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-Bold.woff2') format('woff2');
          font-weight: 700;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-ExtraBold.woff2') format('woff2');
          font-weight: 800;
          font-style: normal;
          font-display: swap;
        }
        @font-face {
          font-family: Vazirmatn;
          src: url('/assets/fonts/webfonts/Vazirmatn-Black.woff2') format('woff2');
          font-weight: 900;
          font-style: normal;
          font-display: swap;
        }

        :root{
          --bg: #f5f7fb;
          --card: #ffffff;
          --muted: #6b7280;
          --text: #0f172a;
          --primary: #2563eb;
          --primary-600: #1d4ed8;
          --line: #e5e7eb;
          --line-soft:#f1f5f9;
          --danger:#ef4444;
          --radius-card:16px;
        }

        *{ box-sizing:border-box; font-family: Vazirmatn, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial, "Noto Sans", "Liberation Sans", sans-serif; }
        html, body{ margin:0; padding:0; background:var(--bg); color:var(--text); }

        @media(min-width:1024px){
          body{ position: relative; background: transparent; }
          body::before{
            content:"";
            position:fixed; inset:0; z-index:-1;
            background:
              radial-gradient(circle at 20% 30%, rgba(37,99,235,.22) 0%, rgba(255,255,255,0) 60%),
              radial-gradient(circle at 80% 20%, rgba(16,185,129,.18) 0%, rgba(255,255,255,0) 60%),
              radial-gradient(circle at 50% 80%, rgba(168,85,247,.16) 0%, rgba(255,255,255,0) 60%),
              linear-gradient(115deg, #f8fafc 0%, #eef2ff 50%, #f9fafb 100%);
            background-size: 140% 140%;
            animation: bgFloat 3s ease-in-out infinite;
          }
        }
        @keyframes bgFloat { 0%{background-position:0% 0%} 50%{background-position:100% 80%} 100%{background-position:0% 0%} }

        .page{ max-width: 1000px; margin: 24px auto; padding: 0 16px; min-height:100vh; display:flex; align-items:center; justify-content:center; }
        @media(min-width:1024px){ .page{ padding-top:32px; padding-bottom:32px; align-items:flex-start; } }

        .card{
          background:var(--card); border:1px solid var(--line); border-radius:var(--radius-card);
          box-shadow: 0 10px 25px rgba(2,6,23,.06); overflow:hidden; position:relative; width:100%; max-width:480px;
          display:flex; flex-direction:column;
        }
        @media(min-width:1024px){
          .card{
            background: radial-gradient(circle at 50% 0%, rgba(255,255,255,1) 0%, rgba(248,250,252,1) 70%);
            border:1px solid rgba(148,163,184,.25);
            box-shadow: 0 40px 80px rgba(15,23,42,.18), 0 4px 16px rgba(0,0,0,.05);
            backdrop-filter: blur(3px); margin-top:40px;
          }
        }

        .card-head{
          display:flex; align-items:center; justify-content:space-between; gap:16px; padding:16px 20px 14px;
          background:var(--card); border-bottom:1px solid var(--line-soft); flex-wrap:nowrap;
        }
        @media(min-width:1024px){
          .card-head{
            padding:20px 24px 16px; border-bottom:1px solid rgba(148,163,184,.18);
            background:linear-gradient(to bottom right, rgba(255,255,255,.9) 0%, rgba(248,250,252,.8) 100%);
          }
        }

        .brand-block{ display:flex; align-items:center; gap:12px; min-width:0; }
        .brand-logo{ width:44px; height:44px; border-radius:12px; background:#fff; border:1px solid var(--line); box-shadow:0 8px 20px rgba(0,0,0,.04); display:flex; align-items:center; justify-content:center; overflow:hidden; flex-shrink:0; }
        .brand-logo img{ width:100%; height:100%; object-fit:contain; display:block; }
        @media(min-width:1024px){
          .brand-logo{
            box-shadow:0 16px 32px rgba(37,99,235,.18); border:1px solid rgba(37,99,235,.3);
            background:radial-gradient(circle at 30% 30%, #fff 0%, #e0e7ff 60%);
          }
        }
        .brand-texts{ display:flex; flex-direction:column; line-height:1.3; }
        .brand-name{ font-size:16px; font-weight:800; color:var(--text); text-decoration:none; }
        .brand-sub-desktop{ font-size:12px; font-weight:600; color:var(--muted); line-height:1.4; display:block; text-align:right; }
        .brand-sub-mobile{ font-size:12px; font-weight:600; color:var(--muted); line-height:1.4; display:none; text-align:right; }

        .head-actions{ display:flex; align-items:center; gap:8px; flex-wrap:nowrap; flex-shrink:0; }
        .head-btn{
          display:inline-flex; align-items:center; justify-content:center; gap:6px; min-height:34px; border-radius:10px;
          font-weight:700; font-size:13px; line-height:1.2; text-decoration:none; padding:8px 12px; transition:all .12s ease;
          box-shadow:0 8px 20px rgba(0,0,0,.06); border:2px solid transparent; color:#fff; white-space:nowrap;
        }
        .btn-telegram{ background:#229ED9; border-color:#229ED9; }
        .btn-telegram:hover{ transform: translateY(-2px) scale(1.03); box-shadow:0 12px 24px rgba(34,158,217,.4); }
        .btn-telegram svg{ width:16px; height:16px; fill:#fff; }
        .btn-guide{ background:#10b981; border-color:#059669; box-shadow:0 8px 20px rgba(16,185,129,.3); }
        .btn-guide:hover{ transform: translateY(-2px) scale(1.03); box-shadow:0 12px 24px rgba(16,185,129,.45); }
        .btn-guide svg{ width:16px; height:16px; fill:#fff; }

        @media(min-width:1024px){
          .head-btn{ border-radius:12px; min-height:40px; font-size:13px; padding:9px 14px; box-shadow:0 16px 32px rgba(15,23,42,.22); }
          .btn-telegram{ background:linear-gradient(to bottom right,#2aa7e2 0%,#1b7fb4 60%); border-color:rgba(34,158,217,.6); }
          .btn-guide{ background:linear-gradient(to bottom right,#10b981 0%,#059669 60%); border-color:rgba(5,150,105,.6); }
        }

        .text-full{ display:inline; } .text-short{ display:none; }
        @media(max-width:500px){
          .card-head{ flex-wrap:nowrap; flex-direction:row; align-items:center; justify-content:space-between; padding:12px 14px; border-bottom:1px solid var(--line); background:#fff; }
          .brand-block{ gap:10px; } .brand-logo{ width:40px; height:40px; border-radius:10px; } .brand-name{ font-size:14px; }
          .brand-sub-desktop{ display:none; } .brand-sub-mobile{ display:block; }
          .head-actions{ gap:6px; } .head-btn{ min-height:32px; font-size:12px; padding:7px 10px; border-radius:8px; box-shadow:0 6px 14px rgba(0,0,0,.15); }
          .text-full{ display:none; } .text-short{ display:inline; }
        }

        .card-body{ padding:20px; }
        .status-head{ text-align:right; margin-bottom:20px; }
        .status-title{ font-size:18px; font-weight:900; margin:0 0 6px; color:var(--danger); line-height:1.4; text-align:center; }
        .status-msg{ font-size:13px; font-weight:600; color:var(--text); line-height:1.8; text-align:center; white-space:pre-line; }

        .info-block{ background:#f9fafb; border:1px solid var(--line); border-radius:12px; padding:12px 16px; font-size:.9rem; line-height:1.6; color:var(--muted); margin:20px 0; }
        .info-row{ display:flex; flex-wrap:wrap; gap:8px; align-items:center; margin-bottom:8px;  justify-content: space-between; }
        .info-label{ color:var(--muted); min-width:90px; font-weight:600; font-size:.8rem; }
        .info-value{ direction:ltr; color:var(--text); font-weight:700; font-size:.9rem; word-break:break-all; }

        .actions{ display:flex; flex-wrap:wrap; align-items:center; justify-content:center; gap:10px; margin-top:16px; margin-bottom:20px; }
        .btn-main{ background:var(--primary); color:#fff; border:none; border-radius:10px; padding:12px 16px; font-size:.9rem; font-weight:800; text-decoration:none; display:inline-flex; align-items:center; justify-content:center; text-align:center; cursor:pointer; box-shadow:0 10px 24px rgba(37,99,235,.25); }
        .btn-main:hover{ background:var(--primary-600); transform: translateY(-1px) scale(1.02); box-shadow:0 16px 32px rgba(29,78,216,.4); }
        .btn-alt{ background:#fff; color:var(--primary); border:2px solid var(--primary); border-radius:10px; padding:12px 16px; font-size:.9rem; font-weight:800; text-decoration:none; display:inline-flex; align-items:center; justify-content:center; text-align:center; cursor:pointer; }
        .btn-alt:hover{ background:var(--primary); color:#fff; }

        .mini-info{ border-top:1px dashed var(--line); padding-top:16px; font-size:.9rem; font-weight:600; line-height:1.7; color:var(--muted); text-align:right; }
        .mini-info ul{ margin:6px 0 0; padding:0 18px; }
        .mini-info li{ margin:4px 0; }
        .mini-info a{ color:var(--primary); font-weight:800; text-decoration:none; }
        .mini-info a:hover{ text-decoration:underline; }

        @media (max-width:640px){
          .info-row{display: flex;flex-direction: row;align-items: center;align-content: space-between;justify-content: space-between;}
          .info-label{min-width:auto}
        }
      </style>
  </head>
  <body>

    <div class="page">
      <div class="card">

        <!-- هدر -->
        <div class="card-head">
          <div class="brand-block">
            <div class="brand-logo">
              <img src="/assets/logo.svg" alt="Diminet" onerror="this.src='/assets/logo.png'">
            </div>
            <div class="brand-texts">
              <a class="brand-name" href="https://diminet.ir" target="_blank" rel="noopener">دیمینت</a>
              <div class="brand-sub-desktop">وضعیت پرداخت</div>
              <div class="brand-sub-mobile">VPN</div>
            </div>
          </div>

          <div class="head-actions">
            <a class="head-btn btn-telegram" href="https://t.me/dimynet" target="_blank" rel="noopener">
              <svg viewBox="0 0 24 24" aria-hidden="true"><path d="M9.036 15.803l-.376 5.3c.538 0 .771-.231 1.049-.508l2.518-2.414 5.215 3.812c.956.528 1.637.251 1.896-.885l3.438-16.12.001-.001c.305-1.422-.513-1.978-1.432-1.63L1.7 9.63c-1.39.539-1.37 1.316-.237 1.668l5.397 1.68L18.718 6.4c.626-.413 1.197-.183.727.23"/></svg>
              <span class="text-full">پشتیبانی تلگرام</span>
              <span class="text-short">تلگرام</span>
            </a>

            <a class="head-btn btn-guide" href="https://diminet.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-vpn-%d9%88-v2ray/" target="_blank" rel="noopener">
              <svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 3c-4.97 0-9 3.134-9 7v8a3 3 0 003 3h12a3 3 0 003-3v-8c0-3.866-4.03-7-9-7zm0 2c3.86 0 7 2.239 7 5v8a1 1 0 01-1 1h-4v-3.586ل1.293 1.293 1.414-1.414L12 12ل-4.707 4.707 1.414 1.414L10 15.414V19H6a1 1 0 01-1-1v-8c0-2.761 3.14-5 7-5z"/></svg>
              <span class="text-full">آموزش اتصال</span>
              <span class="text-short">آموزش</span>
            </a>
          </div>
        </div>

        <!-- بدنه -->
        <div class="card-body">

          <div class="status-head">
            <h1 class="status-title"><?= htmlspecialchars($title) ?></h1>
            <div class="status-msg"><?= nl2br(htmlspecialchars($message)) ?></div>
          </div>

          <?php if ($refId !== '' || $email !== '' || $site_user !== '' || $site_pass !== ''): ?>
          <div class="info-block">
            <?php if ($refId !== ''): ?>
            <div class="info-row">
              <div class="info-label">شناسه تراکنش:</div>
              <div class="info-value"><?= htmlspecialchars($refId) ?></div>
            </div>
            <?php endif; ?>

            <?php if ($email !== ''): ?>
            <div class="info-row">
              <div class="info-label">ایمیل:</div>
              <div class="info-value"><?= htmlspecialchars($email) ?></div>
            </div>
            <?php endif; ?>

            <?php if ($site_user !== ''): ?>
            <div class="info-row">
              <div class="info-label">یوزرنیم سایت:</div>
              <div class="info-value"><?= htmlspecialchars($site_user) ?></div>
            </div>
            <?php endif; ?>

            <?php if ($site_pass !== ''): ?>
            <div class="info-row">
              <div class="info-label">رمز سایت:</div>
              <div class="info-value"><?= htmlspecialchars($site_pass) ?></div>
            </div>
            <?php endif; ?>
          </div>
          <?php endif; ?>

          <div class="actions">
            <a class="btn-main" href="/index.php?show_popup=failed">رفتن به پنل</a>
          </div>

          <div class="mini-info">
            <ul>
              <li>اپ‌ها و آموزش اتصال: <a href="https://diminet.ir" target="_blank" rel="noopener">diminet.ir</a></li>
              <li>اگر مشکلی در پرداخت یا اتصال داری، به <a href="https://t.me/dimynet" target="_blank" rel="noopener">تلگرام</a> یا <a href="https://eitaa.com/dimynet" target="_blank" rel="noopener">ایتا</a> پیام بده.</li>
              <li>قابل استفاده روی اندروید، iOS و ویندوز ✅</li>
            </ul>
          </div>

        </div><!-- /card-body -->

      </div><!-- /card -->
    </div><!-- /page -->

  </body>
  </html>
  <?php
  exit;
}

/* ------------------------------------------------------------------
 *  صفحه موفقیت (تم قبلی + کوکی popup)
 * ------------------------------------------------------------------ */
function render_success_page(array $d) {
  $title     = $d['title'] ?? 'نتیجه';
  $refId     = (string)($d['ref_id'] ?? '');
  $email     = (string)($d['email'] ?? '');
  $plan      = (string)($d['plan'] ?? '');
  $mb_user   = (string)($d['mb_user'] ?? '');
  $sub_full  = (string)($d['sub_full'] ?? '');
  $site_user = (string)($d['site_user'] ?? '');
  $site_pass = (string)($d['site_pass'] ?? '');
  $popupType = isset($d['popup_type']) && $d['popup_type'] !== '' ? (string)$d['popup_type'] : 'success';

  // کوکی برای اینکه app.js بفهمه چه پاپ‌آپی رو باز کنه (اگر خواستی ازش استفاده کنی)
  @setcookie('show_popup', $popupType, [
    'expires'  => time() + 300,
    'path'     => '/',
    'secure'   => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'httponly' => false,
    'samesite' => 'Lax'
  ]);

  $qr_src = '';
  if ($sub_full !== '') {
    $qr_src = 'https://api.qrserver.com/v1/create-qr-code/?size=200x200&margin=0&data=' . rawurlencode($sub_full);
  }
  ?>
  <!DOCTYPE html>
  <html lang="fa" dir="rtl">
  <head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($title) ?> | دیمینت</title>
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <style>
      @font-face{font-family:Vazirmatn;src:url('/assets/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');font-weight:400;font-style:normal;font-display:swap}
      @font-face{font-family:Vazirmatn;src:url('/assets/fonts/webfonts/Vazirmatn-Bold.woff2') format('woff2');font-weight:700;font-style:normal;font-display:swap}
      :root{
        --bg:#f5f7fb;--card:#fff;--muted:#6b7280;--text:#0f172a;
        --primary:#2563eb;--primary-600:#1d4ed8;--line:#e5e7eb;--line-soft:#f1f5f9;
        --ok:#16a34a;--danger:#ef4444;--radius:16px
      }
      *{box-sizing:border-box;font-family:Vazirmatn,system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif}
      html,body{margin:0;padding:0;background:var(--bg);color:var(--text)}
      .page{max-width:1000px;margin:24px auto;padding:0 16px;min-height:100vh;display:flex;align-items:center;justify-content:center}
      @media(min-width:1024px){.page{padding:32px 16px;align-items:flex-start}}
      .card{background:var(--card);border:1px solid var(--line);border-radius:var(--radius);box-shadow:0 10px 25px rgba(2,6,23,.06);overflow:hidden;position:relative;width:100%;max-width:520px;display:flex;flex-direction:column}
      .card-head{display:flex;align-items:center;justify-content:space-between;gap:12px;padding:16px 20px;border-bottom:1px solid var(--line-soft)}
      .brand-block{display:flex;align-items:center;gap:12px;min-width:0}
      .brand-logo{width:44px;height:44px;border-radius:12px;background:#fff;border:1px solid var(--line);display:flex;align-items:center;justify-content:center;overflow:hidden;flex-shrink:0}
      .brand-logo img{width:100%;height:100%;object-fit:contain;display:block}
      .brand-name{font-size:16px;font-weight:800;color:var(--text);text-decoration:none}
      .brand-sub{font-size:12px;font-weight:600;color:var(--muted);line-height:1.4}
      .head-actions{display:flex;align-items:center;gap:8px}
      .head-btn{display:inline-flex;align-items:center;justify-content:center;gap:6px;min-height:34px;border-radius:10px;font-weight:700;font-size:13px;text-decoration:none;padding:8px 12px;color:#fff}
      .btn-telegram{background:#229ED9}
      .btn-guide{background:#10b981}
      .card-body{padding:20px}
      .status-head{text-align:center;margin-bottom:16px}
      .status-title{font-size:18px;font-weight:900;margin:0 0 8px;color:var(--text)}
      .kv{display:flex;gap:8px;align-items:center;margin:8px 0;font-size:13px;font-weight:600;justify-content:space-between}
      .kv .label{color:var(--muted);font-size:12px;font-weight:700}
      .kv .value{direction:ltr;word-break:break-word;font-size:14px;font-weight:700;color:var(--text)}
      .input-like{direction:ltr;width:100%;padding:10px;border:2px solid var(--line);border-radius:10px;background:#fff;color:#0f172a;font-size:14px;font-weight:500}
      .copy-btn{padding:9px 12px;border-radius:10px;background:#334155;color:#fff;text-decoration:none;white-space:nowrap;font-size:12px;font-weight:700;cursor:pointer}
      .cred-box{border:1px solid var(--line);background:#f8fafc;border-radius:14px;padding:14px 12px;margin:12px 0}
      .cred-title{margin:0 0 8px;font-size:14px;font-weight:900;color:#F44336}
      .cred-notice{margin:0 0 8px;font-size:14px;font-weight:900;color:#2196F3;text-align:center;}
      .cred-notice2{margin:0 0 8px;font-size:14px;font-weight:900;color:#2196F3;text-align:center;}
      .qr-wrap{display:flex;gap:12px;align-items:center;justify-content:center;margin-top:8px;flex-wrap:wrap}
      .qr-wrap img{width:180px;height:180px;border-radius:12px;border:1px solid var(--line);background:#fff}
      .actions{display:flex;align-items:center;justify-content:center;margin-top:18px;margin-bottom:20px;gap:10px;}
      .btn-main{background:var(--primary);color:#fff;border:none;border-radius:10px;padding:12px 18px;font-size:16px;font-weight:800;text-decoration:none;display:inline-flex;align-items:center;justify-content:center;cursor:pointer;width:100%;max-width:240px}
      .btn-main:hover{background:var(--primary-600)}
      .mini-info{border-top:1px dashed var(--line);padding-top:14px;font-size:.9rem;font-weight:600;line-height:1.7;color:var(--muted);text-align:right}
      .mini-info a{color:var(--primary);font-weight:800;text-decoration:none}
      @media (max-width:640px){.kv{align-items:flex-start}.copy-btn{align-self:flex-end}}
    </style>
  </head>
  <body>

    <div class="page">
      <div class="card">
        <!-- هدر -->
        <div class="card-head">
          <div class="brand-block">
            <div class="brand-logo">
              <img src="/assets/logo.svg" alt="Diminet" onerror="this.src='/assets/logo.png'">
            </div>
            <div>
              <a class="brand-name" href="https://diminet.ir" target="_blank" rel="noopener">دیمینت</a>
              <div class="brand-sub">نتیجه خرید</div>
            </div>
          </div>
          <div class="head-actions">
            <a class="head-btn btn-telegram" href="https://t.me/dimynet" target="_blank" rel="noopener">پشتیبانی</a>
            <a class="head-btn btn-guide" href="https://diminet.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-vpn-%d9%88-v2ray/" target="_blank" rel="noopener">آموزش اتصال</a>
          </div>
        </div>

        <!-- بدنه -->
        <div class="card-body">
          <div class="status-head">
            <h1 class="status-title"><?= htmlspecialchars($title) ?></h1>
          </div>

          <?php if ($refId !== ''): ?>
          <div class="kv">
            <div class="label">شماره تراکنش:</div>
            <div class="value" id="refId"><?= htmlspecialchars($refId) ?></div>
          </div>
          <?php endif; ?>

          <?php if ($email !== ''): ?>
          <div class="kv">
            <div class="label">ایمیل:</div>
            <div class="value" id="email"><?= htmlspecialchars($email) ?></div>
          </div>
          <?php endif; ?>

          <?php if ($plan !== ''): ?>
          <div class="kv">
            <div class="label">پلن:</div>
            <div class="value" id="plan"><?= htmlspecialchars($plan) ?></div>
          </div>
          <?php endif; ?>

          <?php if ($mb_user !== ''): ?>
          <div class="kv">
            <div class="label">نام کاربری سرویس:</div>
            <div class="value" id="mbUser"><?= htmlspecialchars($mb_user) ?></div>
          </div>
          <?php endif; ?>

          <?php if ($site_user !== '' || $site_pass !== ''): ?>
          <div class="cred-box">
            <h3 class="cred-title">اطلاعات ورود به سایت</h3>
            <h3 class="cred-notice">لطفا اطلاعات ورود خود را اسکرین شات بگیرید</h3>
            <?php if ($site_user !== ''): ?>
            <div class="kv" style="margin-top:6px">
              <div class="label">یوزرنیم سایت:</div>
              <div class="value" id="siteUser"><?= htmlspecialchars($site_user) ?></div>
            </div>
            <?php endif; ?>
            <?php if ($site_pass !== ''): ?>
            <div class="kv">
              <div class="label">رمز سایت:</div>
              <div class="value" id="sitePass"><?= htmlspecialchars($site_pass) ?></div>
              <a class="copy-btn" data-copy="<?= htmlspecialchars($site_pass, ENT_QUOTES) ?>">کپی</a>
            </div>
            <?php endif; ?>
          </div>
          <?php endif; ?>

          <?php if ($sub_full !== ''): ?>
          <div class="cred-box">
            <h3 class="cred-title">لینک اشتراک (Subscription)</h3>
            <div class="kv" style="margin:6px 0">
              <div class="label">کپی سریع:</div>
              <div class="value" style="width:75%">
                <input class="input-like" type="text" id="subLink" value="<?= htmlspecialchars($sub_full) ?>" readonly onclick="this.select()">
              </div>
              <a class="copy-btn" data-copy="<?= htmlspecialchars($sub_full, ENT_QUOTES) ?>">کپی</a>
            </div>
            <?php if ($qr_src): ?>
            <div class="qr-wrap">
              <img src="<?= htmlspecialchars($qr_src) ?>" alt="QR">
            </div>
            <?php endif; ?>
          </div>
          <?php endif; ?>

          <div class="actions">
            <h3 class="cred-notice2">برای دیدن آموزش وارد پنل شوید</h3>
            <!-- اینجا مهمه: لینک به index + show_popup -->
            <a class="btn-main" href="/index.php?show_popup=<?= htmlspecialchars($popupType) ?>">ورود به پنل</a>
          </div>

          <div class="mini-info">
            <ul>
              <li>الان می‌تونی با یوزرنیم و رمز سایت وارد پنل بشی و حجم و زمان باقی‌مونده رو ببینی ✅</li>
              <li>اپ‌ها و آموزش اتصال همیشه داخل
                <a href="https://diminet.ir" target="_blank" rel="noopener">diminet.ir</a> در دسترسه (اندروید / iOS / ویندوز).
              </li>
              <li>اگه اتصال فعال نشد یا خطا داشتی، به
                <a href="https://t.me/dimynet" target="_blank" rel="noopener">پشتیبانی تلگرام</a>
                پیام بده 🙌
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>

    <script>
      document.addEventListener('click', function(e){
        const a = e.target.closest('.copy-btn');
        if (!a) return;
        const val = a.getAttribute('data-copy') || '';
        if (!val) return;
        navigator.clipboard.writeText(val).then(()=>alert('کپی شد!'));
      });
    </script>
  </body>
  </html>
  <?php
  exit;
}


/* ------------------------------------------------------------------
 * ابزار کمکی: پسورد رندوم
 * ------------------------------------------------------------------ */
function generate_random_password(int $length = 8): string {
    $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz23456789';
    $max   = strlen($chars) - 1;
    $out   = '';
    for ($i = 0; $i < $length; $i++) {
        $out .= $chars[random_int(0, $max)];
    }
    return $out;
}

/**
 * ساخت/یافتن کاربر سایت در جدول users
 * قانون پروژه: فقط *اولین خرید* پسورد جدید می‌گیرد و نمایش داده می‌شود.
 *
 * @return array [userRow, isNew, plainPasswordOrNull]
 */
function find_or_create_site_user(PDO $pdo, string $email): array {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :e LIMIT 1");
    $stmt->execute([':e' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        return [$user, false, null];
    }

    $siteUsername = $email;
    $plainPass    = generate_random_password(8);
    $hashPass     = password_hash($plainPass, PASSWORD_DEFAULT);

    $ins = $pdo->prepare("
        INSERT INTO users (email, site_username, site_password, wallet_balance, created_at)
        VALUES (:e, :u, :p, 0, NOW())
    ");
    $ins->execute([
        ':e' => $email,
        ':u' => $siteUsername,
        ':p' => $hashPass,
    ]);

    $userId = (int)$pdo->lastInsertId();

    $_SESSION['user_email'] = $email;
    $_SESSION['user_id']    = $userId;

    $user = [
        'id'            => $userId,
        'email'         => $email,
        'site_username' => $siteUsername,
        'site_password' => $hashPass,
        'wallet_balance'=> 0,
        'created_at'    => date('Y-m-d H:i:s'),
    ];

    return [$user, true, $plainPass];
}

/* ------------------------------------------------------------------
 * ایمیل موفق (همون ظاهر قبلی)
 * ------------------------------------------------------------------ */
function build_success_email_html(array $d): string {
    $title     = htmlspecialchars($d['title'] ?? '', ENT_QUOTES, 'UTF-8');
    $refId     = htmlspecialchars($d['ref_id'] ?? '', ENT_QUOTES, 'UTF-8');
    $email     = htmlspecialchars($d['email'] ?? '', ENT_QUOTES, 'UTF-8');
    $plan      = htmlspecialchars($d['plan'] ?? '', ENT_QUOTES, 'UTF-8');
    $mb_user   = htmlspecialchars($d['mb_user'] ?? '', ENT_QUOTES, 'UTF-8');
    $sub_full  = htmlspecialchars($d['sub_full'] ?? '', ENT_QUOTES, 'UTF-8');
    $site_user = htmlspecialchars($d['site_user'] ?? '', ENT_QUOTES, 'UTF-8');
    $site_pass = htmlspecialchars($d['site_pass'] ?? '', ENT_QUOTES, 'UTF-8');

    $rows = '';

    if ($refId !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right;">شماره تراکنش:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left; direction:ltr;">'.$refId.'</td>
        </tr>';
    }

    if ($email !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right;">ایمیل:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left; direction:ltr;">'.$email.'</td>
        </tr>';
    }

    if ($plan !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right;">پلن:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left;">'.$plan.'</td>
        </tr>';
    }

    if ($mb_user !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right;">نام کاربری سرویس:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left; direction:ltr;">'.$mb_user.'</td>
        </tr>';
    }

    if ($sub_full !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right; vertical-align:top;">لینک اشتراک:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left;">
            <div style="direction:ltr; word-break:break-all; background:#f8fafc; border:1px solid #e5e7eb; border-radius:8px; padding:8px 10px; font-family:\'Tahoma\',sans-serif; font-size:13px; line-height:1.5; color:#0f172a;">
              '.$sub_full.'
            </div>
          </td>
        </tr>';
    }

    if ($site_user !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right;">یوزرنیم سایت:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left; direction:ltr;">'.$site_user.'</td>
        </tr>';
    }

    if ($site_pass !== '') {
        $rows .= '
        <tr>
          <td style="padding:8px 12px; font-size:14px; color:#6b7280; text-align:right;">رمز سایت:</td>
          <td style="padding:8px 12px; font-size:14px; color:#0f172a; text-align:left; direction:ltr;">'.$site_pass.'</td>
        </tr>';
    }

    return '
    <div style="background-color:#f9fafb; padding:24px 12px; direction:rtl; text-align:center; font-family:\'Vazirmatn\',Tahoma,Arial,sans-serif; color:#0f172a; line-height:1.7;">
      <div style="max-width:480px; margin:0 auto; background:#ffffff; border:1px solid #e5e7eb; border-radius:16px; box-shadow:0 10px 25px rgba(2,6,23,.06); padding:20px;">
        
        <div style="text-align:center; margin-bottom:16px;">
          <img src="https://dim.dimob.ir/assets/logo.png" alt="Diminet" style="width:64px; height:64px; border-radius:12px; background:#fff; object-fit:cover; display:block; margin:0 auto 10px auto;">
          <div style="font-weight:800; font-size:16px; color:#0f172a;">دیمینت</div>
          <div style="font-size:13px; color:#6b7280;">'.$title.'</div>
        </div>
        <table style="width:100%; border-collapse:collapse; direction:rtl; text-align:right;">
          <tbody>
            '.$rows.'
          </tbody>
        </table>

        <div style="margin-top:20px; font-size:12px; color:#6b7280; line-height:1.6;">
          برای اتصال، اپ و آموزش را از سایت ما دریافت کن.
          <br>
          <a href="https://diminet.ir" style="color:#2563eb; text-decoration:none; font-weight:700;">diminet.ir</a>
        </div>
      </div>

      <div style="margin-top:16px; font-size:11px; color:#94a3b8; line-height:1.6;">
        این ایمیل به صورت خودکار ارسال شده است. اگر شما این خرید را انجام نداده‌اید لطفاً فوراً با پشتیبانی تماس بگیرید.
      </div>
    </div>';
}

/* ------------------------------------------------------------------
 * ایمیل ناموفق (پرداخت ناموفق درگاه)
 * ------------------------------------------------------------------ */
function send_failed_payment_email(string $email, string $site_username, bool $isNewUser, ?string $site_password, string $failRef): void {
    $subject_failed = "پرداخت ناموفق - Diminet VPN";

    $rows = '';
    if ($failRef !== '') {
      $rows .= '<tr><td style="padding:8px 12px;font-size:14px;color:#6b7280;text-align:right;">شناسه تراکنش:</td><td style="padding:8px 12px;font-size:14px;color:#0f172a;text-align:left;direction:ltr;">'.htmlspecialchars($failRef,ENT_QUOTES,'UTF-8').'</td></tr>';
    }
    $rows .= '<tr><td style="padding:8px 12px;font-size:14px;color:#6b7280;text-align:right;">ایمیل:</td><td style="padding:8px 12px;font-size:14px;color:#0f172a;text-align:left;direction:ltr;">'.htmlspecialchars($email,ENT_QUOTES,'UTF-8').'</td></tr>';
    $rows .= '<tr><td style="padding:8px 12px;font-size:14px;color:#6b7280;text-align:right;">یوزرنیم سایت:</td><td style="padding:8px 12px;font-size:14px;color:#0f172a;text-align:left;direction:ltr;">'.htmlspecialchars($site_username,ENT_QUOTES,'UTF-8').'</td></tr>';
    if ($isNewUser && $site_password !== '') {
      $rows .= '<tr><td style="padding:8px 12px;font-size:14px;color:#6b7280;text-align:right;">رمز سایت:</td><td style="padding:8px 12px;font-size:14px;color:#0f172a;text-align:left;direction:ltr;">'.htmlspecialchars($site_password,ENT_QUOTES,'UTF-8').'</td></tr>';
    }

    $failedHtml =
      '<div style="background-color:#f9fafb;padding:24px 12px;direction:rtl;text-align:center;font-family:\'Vazirmatn\',Tahoma,Arial,sans-serif;color:#0f172a;line-height:1.7;">'.
        '<div style="max-width:480px;margin:0 auto;background:#ffffff;border:1px solid #e5e7eb;border-radius:16px;box-shadow:0 10px 25px rgba(2,6,23,.06);padding:20px;">'.
          '<div style="text-align:center;margin-bottom:10px;"><img src="https://dim.dimob.ir/assets/logo.png" alt="Diminet" style="width:56px;height:56px;border-radius:12px;background:#fff;object-fit:cover;display:block;margin:0 auto 8px auto;"><div style="font-weight:800;font-size:16px;color:#0f172a;">پرداخت ناموفق</div><div style="font-size:13px;color:#6b7280;">اگر مبلغ از حساب شما کم شده، لطفاً با پشتیبانی تماس بگیرید.</div></div>'.
          '<table style="width:100%;border-collapse:collapse;direction:rtl;text-align:right;"><tbody>'.$rows.'</tbody></table>'.
          '<div style="margin-top:14px;font-size:12px;color:#6b7280;">برای پیگیری سریع به <a href="https://t.me/dimynet" style="color:#2563eb;text-decoration:none;font-weight:700;">تلگرام</a> یا <a href="https://eitaa.com/dimynet" style="color:#2563eb;text-decoration:none;font-weight:700;">ایتا</a> پیام بده.</div>'.
        '</div>'.
      '</div>';

    $failedAlt =
      "پرداخت شما ناموفق بود.\n".
      ($failRef ? "شناسه تراکنش: $failRef\n" : "").
      "ایمیل: $email\n".
      "یوزرنیم سایت: $site_username\n".
      ($isNewUser && $site_password ? "رمز سایت: $site_password\n" : "اگر قبلاً عضو بوده‌اید، از رمز قبلی استفاده کنید.\n").
      "برای پیگیری سریع: t.me/dimynet یا eitaa.com/dimynet\n";

    try {
      send_mail($email, $subject_failed, $failedHtml, $failedAlt);
    } catch (Throwable $e) {
      error_log('MAIL_FAIL_FAILED_PAYMENT: '.$e->getMessage());
    }
}

/* ------------------------------------------------------------------
 * اگر لازم شد مبلغ درگاه رو به کیف پول برگردونیم
 * ------------------------------------------------------------------ */
function maybe_convert_payment_to_wallet(PDO $pdo, array $payment, array $siteUserRow): void {
    $kind        = (string)($payment['kind'] ?? 'service');
    $converted   = (int)($payment['converted_to_wallet'] ?? 0);
    $gatewayPart = (int)($payment['gateway_amount_rial'] ?? 0);
    $amountRial  = (int)($payment['amount_rial'] ?? 0);
    $userId      = (int)$siteUserRow['id'];
    $paymentId   = (int)$payment['id'];

    if ($kind !== 'service') {
        return;
    }
    if ($converted || $userId <= 0) {
        return;
    }

    // اگر چیزی از درگاه پرداخت نشده، چیزی برای برگردوندن نیست
    if ($gatewayPart <= 0) {
        return;
    }

    $ok = wallet_charge_from_gateway(
        $pdo,
        $userId,
        $gatewayPart,
        $paymentId,
        'بازگشت مبلغ درگاه به کیف پول (خطا در ساخت/تمدید سرویس)'
    );
    if ($ok) {
        $st = $pdo->prepare("UPDATE payments SET converted_to_wallet = 1 WHERE id = :id");
        $st->execute([':id' => $paymentId]);
    }
}

/* ==================================================================
 *  شروع لاجیک اصلی callback
 * ================================================================== */

$isFree = (isset($_GET['free']) && $_GET['free'] == '1' && isset($_GET['pid']) && ctype_digit((string)$_GET['pid']));
$payment = null;
$refId   = null;

// 1) واکشی رکورد payment
if ($isFree) {
    $pid = (int)$_GET['pid'];

    $stmt = $pdo->prepare("SELECT * FROM payments WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $pid]);
    $payment = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$payment) {
        render_error_page(
            'پرداخت پیدا نشد',
            "اطلاعات این پرداخت در سیستم پیدا نشد.\nاگر فکر می‌کنی خطایی رخ داده، لطفاً به پشتیبانی پیام بده."
        );
    }

    $refId = (string)($payment['ref_id'] ?? '');
    if ($refId === '') {
        $refId = 'FREE-' . time();
        $pdo->prepare("UPDATE payments SET ref_id = :r WHERE id = :id")
            ->execute([':r' => $refId, ':id' => $payment['id']]);
        $payment['ref_id'] = $refId;
    }

    if ($payment['status'] !== 'paid') {
        $pdo->prepare("UPDATE payments SET status='paid' WHERE id=:id")
            ->execute([':id' => $payment['id']]);
        $payment['status'] = 'paid';
    }

} else {
    $authority = trim($_GET['Authority'] ?? '');
    $status    = trim($_GET['Status'] ?? '');

    if ($authority === '' || $status === '') {
        render_error_page(
            'بازگشت نامعتبر از درگاه',
            "در پردازش نتیجه پرداخت مشکلی پیش آمد.\nاگر مبلغی از حساب شما کسر شده، لطفاً با پشتیبانی در ارتباط باش."
        );
    }

    $stmt = $pdo->prepare("SELECT * FROM payments WHERE authority = :a LIMIT 1");
    $stmt->execute([':a' => $authority]);
    $payment = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$payment) {
        render_error_page(
            'پرداخت پیدا نشد',
            "تراکنشی با این شناسه در سیستم ثبت نشده است.\nاگر مبلغ از حسابت کم شده، اسکرین‌ شات همین صفحه را برای پشتیبانی ارسال کن."
        );
    }

    $email = (string)$payment['email'];

    if (strcasecmp($status, 'OK') !== 0) {

        [$siteUserRow, $isNew, $plainPass] = find_or_create_site_user($pdo, $email);

        $failRef = $payment['ref_id'] ?? '';
        if ($failRef === '' || $failRef === null) {
            $failRef = 'FAIL-' . time();
            $pdo->prepare("UPDATE payments SET status='failed', ref_id=:r WHERE id=:id")
                ->execute([':r' => $failRef, ':id' => $payment['id']]);
        } else {
            $pdo->prepare("UPDATE payments SET status='failed' WHERE id=:id")
                ->execute([':id' => $payment['id']]);
        }

        send_failed_payment_email(
            $email,
            $siteUserRow['site_username'],
            $isNew,
            $isNew && $plainPass ? $plainPass : '',
            $failRef
        );

        render_error_page(
            'پرداخت ناموفق',
            "پرداخت توسط درگاه تایید نشد یا توسط شما لغو شد.\nاگر مبلغ از حساب شما کم شده، معمولاً طی چند دقیقه به‌صورت خودکار برگشت می‌خورد.",
            $failRef,
            $email,
            $siteUserRow['site_username'],
            $isNew && $plainPass ? $plainPass : ''
        );
    }

    $merchantID = getenv('ZARINPAL_MERCHANT_ID') ?: get_setting('zarinpal_merchant_id', '');
    if ($merchantID === '') {

        [$siteUserRow, $isNew, $plainPass] = find_or_create_site_user($pdo, $email);

        render_error_page(
            'خطای تنظیمات درگاه',
            "پرداخت از سمت زرین‌پال تایید شده، اما مرچنت در سرور تنظیم نشده است.\nلطفاً با پشتیبانی در ارتباط باش تا به‌صورت دستی بررسی کنند.",
            '',
            $email,
            $siteUserRow['site_username'],
            $isNew && $plainPass ? $plainPass : ''
        );
    }

    $verifyData = [
        'merchant_id' => $merchantID,
        'amount'      => (int)$payment['gateway_amount_rial'] ?: (int)$payment['amount_rial'],
        'authority'   => $authority,
    ];

    $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: application/json','Accept: application/json'],
        CURLOPT_POSTFIELDS     => json_encode($verifyData, JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT        => 30,
    ]);
    $resp = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr  = curl_error($ch);
    curl_close($ch);

    if ($resp === false || $httpCode !== 200) {

        [$siteUserRow, $isNew, $plainPass] = find_or_create_site_user($pdo, $email);

        render_error_page(
            'خطا در تأیید پرداخت',
            "پرداخت از سمت درگاه انجام شده ولی در مرحله تأیید نهایی خطایی رخ داد.\nاگر مبلغ از حساب شما کم شده، لطفاً با پشتیبانی در ارتباط باش.",
            '',
            $email,
            $siteUserRow['site_username'],
            $isNew && $plainPass ? $plainPass : ''
        );
    }

    $verifyRes = json_decode($resp, true);
    $dataCode  = $verifyRes['data']['code'] ?? null;

    if ($dataCode !== 100 && $dataCode !== 101) {
        $errMsg  = $verifyRes['errors']['message'] ?? 'خطای نامشخص در تأیید پرداخت';
        $errCode = $verifyRes['errors']['code'] ?? 'N/A';

        [$siteUserRow, $isNew, $plainPass] = find_or_create_site_user($pdo, $email);

        $pdo->prepare("UPDATE payments SET status='failed' WHERE id=:id")
            ->execute([':id' => $payment['id']]);

        send_failed_payment_email(
            $email,
            $siteUserRow['site_username'],
            $isNew,
            $isNew && $plainPass ? $plainPass : '',
            ''
        );

        render_error_page(
            'خطا در تأیید پرداخت',
            "در تأیید پرداخت از طرف زرین‌پال مشکلی پیش آمد.\nپیام درگاه: {$errMsg} (کد {$errCode})",
            '',
            $email,
            $siteUserRow['site_username'],
            $isNew && $plainPass ? $plainPass : ''
        );
    }

    $refId = $verifyRes['data']['ref_id'] ?? null;
    if ($refId === '' || $refId === null) {
        $refId = 'ZP-' . time();
    }

    $pdo->prepare("UPDATE payments SET status='paid', ref_id=:r WHERE id=:id")
        ->execute([':r' => $refId, ':id' => $payment['id']]);

    $payment['status'] = 'paid';
    $payment['ref_id'] = $refId;
}

/* ------------------------------------------------------------------
 * بعد از اینجا: پرداخت قطعاً paid است
 * ------------------------------------------------------------------ */
$email      = (string)$payment['email'];
$planCode   = (string)$payment['plan'];
$renewUser  = trim($payment['renew_username'] ?? '');
$amountRial = (int)$payment['amount_rial'];
$kind       = (string)($payment['kind'] ?? 'service');
$walletUsed = (int)($payment['wallet_used_rial'] ?? 0);
$gatewayAmt = (int)($payment['gateway_amount_rial'] ?? 0);

[$siteUserRow, $isNewSiteUser, $plainSitePass] = find_or_create_site_user($pdo, $email);
$siteUsername = $siteUserRow['site_username'];

// اگر نوع پرداخت wallet است → فقط شارژ کیف پول، بدون ساخت سرویس
if ($kind === 'wallet') {

    $userId = (int)$siteUserRow['id'];

    if ((int)$payment['converted_to_wallet'] === 0 && $amountRial > 0) {
        wallet_charge_from_gateway(
            $pdo,
            $userId,
            $amountRial,
            (int)$payment['id'],
            'شارژ کیف پول از درگاه زرین‌پال'
        );
        $pdo->prepare("UPDATE payments SET converted_to_wallet = 1 WHERE id = :id")
            ->execute([':id' => $payment['id']]);
    }

    // برای صفحه موفق کیف پول: فقط عنوان + رسید + نوع پاپ‌آپ
    $successDataWallet = [
      'title'      => 'شارژ کیف پول با موفقیت انجام شد 🎉',
      'ref_id'     => $payment['ref_id'] ?? '',
      'plan'       => 'شارژ کیف پول',
      'popup_type' => 'wallet_ok', // این مهمه
    ];

    $subject_wallet = "شارژ کیف پول - Diminet VPN";
    $htmlWallet = build_success_email_html($successDataWallet);
    $altWallet  = "کیف پول شما با موفقیت شارژ شد.\n"
                . "مبلغ شارژ: {$amountRial} ریال\n"
                . "ایمیل: {$email}\n"
                . "برای مشاهده موجودی و خرید سرویس به diminet.ir برو.\n";

    try {
        send_mail($email, $subject_wallet, $htmlWallet, $altWallet);
    } catch (Throwable $e) {
        error_log('MAIL_FAIL_WALLET_TOPUP: '.$e->getMessage());
    }

    render_success_page($successDataWallet);
}

/* ------------------------------------------------------------------
 * از اینجا به بعد: kind = service → ساخت/تمدید سرویس VPN
 * ------------------------------------------------------------------ */

$plan = get_plan($planCode);
if (!$plan) {
    maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

    render_error_page(
        'پلن پیدا نشد بعد از پرداخت',
        "پرداخت با موفقیت انجام شده ولی پلن مربوطه در سیستم پیدا نشد.\nلطفاً با پشتیبانی در ارتباط باش.",
        $payment['ref_id'] ?? '',
        $email,
        $siteUsername,
        $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
    );
}

$panelId = (int)($plan['panel_id'] ?? 0);
if ($panelId <= 0) {
    maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

    render_error_page(
        'سرور برای پلن تنظیم نشده',
        "پرداخت موفق بوده اما برای این پلن هیچ سروری تنظیم نشده است.\nلطفاً با پشتیبانی در ارتباط باش.",
        $payment['ref_id'] ?? '',
        $email,
        $siteUsername,
        $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
    );
}

$stPanel = $pdo->prepare("SELECT * FROM vpn_panels WHERE id = :id AND is_active = 1 LIMIT 1");
$stPanel->execute([':id' => $panelId]);
$panelRow = $stPanel->fetch(PDO::FETCH_ASSOC);

if (!$panelRow) {
    maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

    render_error_page(
        'سرور غیرفعال است',
        "پرداختت موفق بود اما سرور مرتبط با این پلن در حال حاضر فعال نیست.\nلطفاً با پشتیبانی در ارتباط باش.",
        $payment['ref_id'] ?? '',
        $email,
        $siteUsername,
        $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
    );
}

$panelType = strtolower(trim($panelRow['type'] ?? 'marzban'));

// مقادیر پلن برای حجم / انقضا
$data_limit_gb    = (int)($plan['data_limit_gb'] ?? 0);
$data_limit_bytes = $data_limit_gb > 0 ? $data_limit_gb * 1024 * 1024 * 1024 : 0;

$duration_days   = (int)($plan['duration_days'] ?? 0);
$duration_months = (int)($plan['duration_months'] ?? 0);
if ($duration_days > 0) {
    $expire_ts_for_new = time() + ($duration_days * 86400);
    $expire_days_for_xui = $duration_days;
} else {
    $months = max(1, $duration_months);
    $expire_ts_for_new = strtotime("+{$months} month");
    $expire_days_for_xui = $months * 30;
}

/* ------------------------------------------------------------------
 * شاخه Marzban
 * ------------------------------------------------------------------ */
if ($panelType === 'marzban') {
    try {
        $mb = new MarzbanService($pdo, $panelRow);
    } catch (Throwable $e) {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'خطای اتصال به سرور',
            "پرداخت موفق بود اما هنگام اتصال به سرور VPN مشکلی پیش آمد.\nلطفاً با پشتیبانی در ارتباط باش.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    if ($renewUser !== '') {

        $info = $mb->getUser($renewUser);
        if ($info['code'] !== 200 || !is_array($info['json'])) {
            maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

            render_error_page(
                'تمدید کامل نشد',
                "پرداخت شما ثبت شد ولی دریافت اطلاعات سرویس برای تمدید ناموفق بود.\nلطفاً با پشتیبانی در ارتباط باش.",
                $payment['ref_id'] ?? '',
                $email,
                $siteUsername,
                $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
            );
        }

        $userData = $info['json'];

        if ($duration_days > 0) {
            $newExpire = time() + ($duration_days * 86400);
        } else {
            $newExpire = strtotime('+' . max(1, $duration_months) . ' month');
        }

        $putBody = [
            "expire"     => $newExpire,
            "data_limit" => $data_limit_bytes,
            "data_limit_reset_strategy" => "no_reset",
            "inbounds"   => new stdClass(),
            "proxies"    => new stdClass(),
            "note"       => null
        ];

        $upRes = $mb->renewUser($renewUser, $putBody);
        if ($upRes['code'] !== 200) {
            maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

            render_error_page(
                'تمدید کامل نشد',
                "پرداخت شما ثبت شد ولی تمدید سرویس کامل انجام نشد.\nلطفاً با پشتیبانی در ارتباط باش.",
                $payment['ref_id'] ?? '',
                $email,
                $siteUsername,
                $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
            );
        }

        $mb->resetTraffic($renewUser);

        $info2 = $mb->getUser($renewUser);
        if ($info2['code'] === 200 && is_array($info2['json'])) {
            $userData = $info2['json'];
        }

        $expire_unix = (int)($userData['expire'] ?? $newExpire);
        $expire_at   = date('Y-m-d H:i:s', $expire_unix);

        $sub_rel  = '';
        $sub_full = '';
        if (!empty($userData['subscription_url'])) {
            $sub_rel = $userData['subscription_url'];
        } elseif (!empty($userData['links']) && is_array($userData['links'])) {
            $first = reset($userData['links']);
            if (is_string($first)) {
                $sub_rel = $first;
            }
        }

        if ($sub_rel !== '' && strpos($sub_rel, '/sub/') === 0) {
            $sub_full = rtrim($mb->getBaseUrl(), '/') . $sub_rel;
        } else {
            $sub_full = $sub_rel;
        }

        $stSvc = $pdo->prepare("
            SELECT * FROM services
            WHERE marzban_user = :u
            ORDER BY id DESC
            LIMIT 1
        ");
        $stSvc->execute([':u' => $renewUser]);
        $svc = $stSvc->fetch(PDO::FETCH_ASSOC);

        if ($svc) {
            $upd = $pdo->prepare("
                UPDATE services
                   SET panel_id        = :pid,
                       plan_size_gb    = :sz,
                       expire_at       = :exp_at,
                       status          = 'active',
                       data_limit_bytes= :limit,
                       expire_unix     = :exp_unix,
                       subscription_url= :sub,
                       connection_info = :conn,
                       last_synced_at  = NOW()
                 WHERE id = :id
            ");
            $upd->execute([
                ':pid'      => $panelId,
                ':sz'       => $data_limit_gb,
                ':exp_at'   => $expire_at,
                ':limit'    => $data_limit_bytes,
                ':exp_unix' => $expire_unix,
                ':sub'      => $sub_full,
                ':conn'     => json_encode($userData, JSON_UNESCAPED_UNICODE),
                ':id'       => $svc['id'],
            ]);
            $serviceId = (int)$svc['id'];
        } else {
            $ins = $pdo->prepare("
                INSERT INTO services
                    (user_id, panel_id, marzban_user, marzban_uid, subscription_url,
                     connection_info, plan_size_gb, expire_at, status, data_limit_bytes,
                     used_bytes, up_bytes, down_bytes, expire_unix, inbound_tag, inbound_id,
                     last_synced_at, created_at)
                VALUES
                    (:uid, :pid, :muser, :muid, :sub,
                     :conn, :sz, :exp_at, 'active', :limit,
                     0, 0, 0, :exp_unix, :itag, NULL, NOW(), NOW())
            ");
            $ins->execute([
                ':uid'      => $siteUserRow['id'],
                ':pid'      => $panelId,
                ':muser'    => $renewUser,
                ':muid'     => ($userData['uid'] ?? null),
                ':sub'      => $sub_full,
                ':conn'     => json_encode($userData, JSON_UNESCAPED_UNICODE),
                ':sz'       => $data_limit_gb,
                ':exp_at'   => $expire_at,
                ':limit'    => $data_limit_bytes,
                ':exp_unix' => $expire_unix,
                ':itag'     => ($plan['inbound_tags'] ?? null),
            ]);
            $serviceId = (int)$pdo->lastInsertId();
        }

        // خرج کیف پول اگر مقداری تعیین شده بود
        if ($walletUsed > 0) {
            wallet_spend_for_service(
                $pdo,
                (int)$siteUserRow['id'],
                $walletUsed,
                $serviceId,
                (int)$payment['id'],
                'تمدید سرویس با استفاده از کیف پول'
            );
        }

        $successDataRenew = [
            'title'     => 'تمدید با موفقیت انجام شد 🎉',
            'ref_id'    => $payment['ref_id'] ?? '',
            'email'     => $email,
            'plan'      => $plan['title'] ?? $planCode,
            'mb_user'   => $renewUser,
            'sub_full'  => $sub_full,
            'site_user' => $siteUsername,
            'site_pass' => $isNewSiteUser && $plainSitePass ? $plainSitePass : '',
        ];

        $subject_renew = "Diminet VPN";
        $htmlBodyRenew = build_success_email_html($successDataRenew);
        $altBodyRenew  = "سرویس شما با موفقیت تمدید شد.\n\n"
                       . "یوزرنیم سرویس: {$successDataRenew['mb_user']}\n"
                       . "لینک اشتراک: {$successDataRenew['sub_full']}\n\n"
                       . "راهنما: diminet.ir\n";

        try {
            send_mail($email, $subject_renew, $htmlBodyRenew, $altBodyRenew);
        } catch (Throwable $e) {
            error_log('MAIL_FAIL_RENEW: '.$e->getMessage());
        }

        render_success_page($successDataRenew);
    }

    // خرید جدید روی مرزبان
    do {
        $random_number  = mt_rand(100000, 999999);
        $username_vless = "Diminet.ir-$random_number";

        $stmtCheck = $pdo->prepare("SELECT id FROM services WHERE marzban_user = :u LIMIT 1");
        $stmtCheck->execute([':u' => $username_vless]);
        $exists = $stmtCheck->fetch(PDO::FETCH_ASSOC);
    } while ($exists);

    $raw        = trim((string)($plan['inbound_tags'] ?? ''));
    $normalized = str_replace(["\r", "\n", "\t", "،"], ',', $raw);
    $parts      = explode(',', $normalized);
    $inbound_tags = [];
    foreach ($parts as $p) {
        $t = trim($p);
        if ($t !== '' && !in_array($t, $inbound_tags, true)) {
            $inbound_tags[] = $t;
        }
    }
    if (empty($inbound_tags)) {
        $inbound_tags = ['GRPC443'];
    }

    $postData = [
      "data_limit" => $data_limit_bytes,
      "data_limit_reset_strategy" => "no_reset",
      "expire" => (int)$expire_ts_for_new,
      "inbounds" => [
          "vless" => $inbound_tags
      ],
      "next_plan" => [
          "add_remaining_traffic" => false,
          "data_limit" => 0,
          "expire" => 0,
          "fire_on_either" => true
      ],
      "note" => "",
      "on_hold_expire_duration" => 0,
      "on_hold_timeout" => "2025-12-31T23:59:59",
      "proxies" => [
          "vless" => new stdClass()
      ],
      "status" => "active",
      "username" => $username_vless
    ];

    $newRes = $mb->createUser($postData);
    if (!in_array($newRes['code'], [200, 201], true)) {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'ساخت اکانت کامل نشد',
            "پرداخت شما ثبت شد ولی ایجاد سرویس روی سرور با مشکل مواجه شد.\nلطفاً با پشتیبانی تماس بگیر و شماره تراکنش را ارسال کن.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $responseData = $newRes['json'];
    if (!$responseData || !isset($responseData['username'])) {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'ساخت اکانت کامل نشد',
            "پرداخت شما ثبت شد ولی پاسخ ایجاد سرویس از سرور معتبر نبود.\nلطفاً با پشتیبانی تماس بگیر.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $marzban_user     = $responseData['username'];
    $marzban_uid      = $responseData['uid'] ?? ($responseData['uuid'] ?? '');
    $subscription_url = $responseData['subscription_url'] ?? '';
    $plan_size_gb     = $data_limit_gb;
    $expire_at        = date("Y-m-d H:i:s", (int)$expire_ts_for_new);

    $subscription_full = $subscription_url;
    if ($subscription_url !== '' && strpos($subscription_url, '/sub/') === 0) {
        $subscription_full = rtrim($mb->getBaseUrl(), '/') . $subscription_url;
    }

    $insSvc = $pdo->prepare("
      INSERT INTO services (
        user_id, panel_id, marzban_user, marzban_uid,
        subscription_url, connection_info,
        plan_size_gb, expire_at, status,
        data_limit_bytes, used_bytes, up_bytes, down_bytes,
        expire_unix, inbound_tag, inbound_id, last_synced_at, created_at
      )
      VALUES (
        :uid, :pid, :muser, :muid,
        :sub, :conn,
        :gb, :exp, 'active',
        :dl, 0, 0, 0,
        :exp_unix, :itag, NULL, NOW(), NOW()
      )
    ");
    $insSvc->execute([
      ':uid'      => $siteUserRow['id'],
      ':pid'      => $panelId,
      ':muser'    => $marzban_user,
      ':muid'     => $marzban_uid,
      ':sub'      => $subscription_full,
      ':conn'     => json_encode($responseData, JSON_UNESCAPED_UNICODE),
      ':gb'       => $plan_size_gb,
      ':exp'      => $expire_at,
      ':dl'       => $data_limit_bytes,
      ':exp_unix' => $expire_ts_for_new,
      ':itag'     => $plan['inbound_tags'] ?? null,
    ]);
    $serviceId = (int)$pdo->lastInsertId();

    if ($walletUsed > 0) {
        wallet_spend_for_service(
            $pdo,
            (int)$siteUserRow['id'],
            $walletUsed,
            $serviceId,
            (int)$payment['id'],
            'خرید سرویس با استفاده از کیف پول'
        );
    }

    $successDataNew = [
      'title'     => 'پرداخت موفق بود 🎉',
      'ref_id'    => $payment['ref_id'] ?? '',
      'email'     => $email,
      'plan'      => $plan['title'] ?? $planCode,
      'mb_user'   => $marzban_user,
      'sub_full'  => $subscription_full,
      'site_user' => $siteUsername,
      'site_pass' => $isNewSiteUser && $plainSitePass ? $plainSitePass : '',
    ];

    $subject_new   = "Diminet VPN";
    $htmlBodyNew   = build_success_email_html($successDataNew);
    $altBodyNew    = "خرید شما با موفقیت انجام شد.\n\n"
                   . "یوزرنیم سرویس: {$successDataNew['mb_user']}\n"
                   . "لینک اشتراک: {$successDataNew['sub_full']}\n"
                   . "یوزرنیم سایت: {$successDataNew['site_user']}\n"
                   . ($successDataNew['site_pass'] !== '' ? "رمز سایت: {$successDataNew['site_pass']}\n" : "")
                   . "\nراهنما: diminet.ir\n";

    try {
        send_mail($email, $subject_new, $htmlBodyNew, $altBodyNew);
    } catch (Throwable $e) {
        error_log('MAIL_FAIL_NEW: '.$e->getMessage());
    }

    render_success_page($successDataNew);
}

/* ------------------------------------------------------------------
 * شاخه X-UI
 * ------------------------------------------------------------------ */
if ($panelType === 'xui') {

    $serverId = trim($panelRow['panel_key'] ?? '');
    if ($serverId === '') {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'تنظیمات X-UI ناقص است',
            "پرداخت موفق بوده اما server_id برای این سرور تنظیم نشده است.\nلطفاً با پشتیبانی در ارتباط باش.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $xuiInboundId = (int)($plan['xui_inbound_id'] ?? 0);
    if ($xuiInboundId <= 0 && $renewUser === '') {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'اینباند X-UI تنظیم نشده',
            "پرداخت موفق بود اما inbound_id برای این پلن روی X-UI تنظیم نشده.\nلطفاً با پشتیبانی در ارتباط باش.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $scheme = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https://' : 'http://';
    $host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $xuiUrl = $scheme . $host . '/xui.php';


    if ($renewUser !== '') {

        $stSvc = $pdo->prepare("
            SELECT * FROM services
             WHERE marzban_user = :u AND panel_id = :pid
             ORDER BY id DESC
             LIMIT 1
        ");
        $stSvc->execute([
            ':u'   => $renewUser,
            ':pid' => $panelId,
        ]);
        $svc = $stSvc->fetch(PDO::FETCH_ASSOC);

        if (!$svc) {
            maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

            render_error_page(
                'سرویس برای تمدید پیدا نشد',
                "پرداخت موفق بود ولی سرویس قبلی برای تمدید روی X-UI پیدا نشد.\nلطفاً با پشتیبانی در ارتباط باش.",
                $payment['ref_id'] ?? '',
                $email,
                $siteUsername,
                $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
            );
        }

        $clientEmail = $renewUser;
        $clientUuid  = (string)($svc['marzban_uid'] ?? '');
        $inboundId   = (int)($svc['inbound_id'] ?? 0);
        if ($inboundId <= 0) {
            $inboundId = $xuiInboundId;
        }
        if ($clientUuid === '' || $inboundId <= 0) {
            maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

            render_error_page(
                'اطلاعات ناقص برای تمدید X-UI',
                "پرداخت موفق بود ولی اطلاعات کلاینت یا اینباند برای تمدید X-UI ناقص است.\nلطفاً با پشتیبانی در ارتباط باش.",
                $payment['ref_id'] ?? '',
                $email,
                $siteUsername,
                $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
            );
        }

        $payload = [
            'action'       => 'renew_service',
            'server_id'    => $serverId,
            'inbound_id'   => $inboundId,
            'client_email' => $clientEmail,
            'client_uuid'  => $clientUuid,
            'total_gb'     => $data_limit_gb,
            'expire_days'  => $expire_days_for_xui,
        ];

        $ch = curl_init($xuiUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_HTTPHEADER     => ['Content-Type: application/json','Accept: application/json'],
            CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
            CURLOPT_TIMEOUT        => 30,
        ]);
        $resp = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlErr  = curl_error($ch);
        curl_close($ch);

        if ($resp === false || $httpCode !== 200) {
            maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

            render_error_page(
                'تمدید کامل نشد',
                "پرداخت شما ثبت شد ولی اتصال به X-UI برای تمدید سرویس با مشکل مواجه شد.\nلطفاً با پشتیبانی در ارتباط باش.",
                $payment['ref_id'] ?? '',
                $email,
                $siteUsername,
                $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
            );
        }

        $json = json_decode($resp, true);
        if (!is_array($json) || empty($json['ok'])) {
            maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

            render_error_page(
                'تمدید کامل نشد',
                "پرداخت ثبت شد ولی X-UI تمدید سرویس را تایید نکرد.\nلطفاً با پشتیبانی در ارتباط باش.",
                $payment['ref_id'] ?? '',
                $email,
                $siteUsername,
                $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
            );
        }

        $svcData = $json['service'] ?? [];
        $subId   = (string)($svcData['sub_id'] ?? '');
        $subscription_full = '';
        if ($subId !== '') {
            // استفاده از هاست پنل + پورت 5050 + /subs/ + subId
            $subscription_full = build_xui_subscription_full($panelRow['base_url'] ?? '', $subId);
        }

        $expire_at = date('Y-m-d H:i:s', time() + $expire_days_for_xui*86400);
        $expire_unix = time() + $expire_days_for_xui*86400;

        $upd = $pdo->prepare("
            UPDATE services
               SET panel_id        = :pid,
                   plan_size_gb    = :sz,
                   expire_at       = :exp_at,
                   status          = 'active',
                   data_limit_bytes= :limit,
                   expire_unix     = :exp_unix,
                   subscription_url= :sub,
                   last_synced_at  = NOW()
             WHERE id = :id
        ");
        $upd->execute([
            ':pid'      => $panelId,
            ':sz'       => $data_limit_gb,
            ':exp_at'   => $expire_at,
            ':limit'    => $data_limit_bytes,
            ':exp_unix' => $expire_unix,
            ':sub'      => $subscription_full,
            ':id'       => $svc['id'],
        ]);
        $serviceId = (int)$svc['id'];

        if ($walletUsed > 0) {
            wallet_spend_for_service(
                $pdo,
                (int)$siteUserRow['id'],
                $walletUsed,
                $serviceId,
                (int)$payment['id'],
                'تمدید سرویس X-UI با استفاده از کیف پول'
            );
        }

        $successDataRenew = [
          'title'     => 'تمدید با موفقیت انجام شد 🎉',
          'ref_id'    => $payment['ref_id'] ?? '',
          'email'     => $email,
          'plan'      => $plan['title'] ?? $planCode,
          'mb_user'   => $clientEmail,
          'sub_full'  => $subscription_full,
          'site_user' => $siteUsername,
          'site_pass' => $isNewSiteUser && $plainSitePass ? $plainSitePass : '',
        ];

        $subject_renew = "Diminet VPN";
        $htmlBodyRenew = build_success_email_html($successDataRenew);
        $altBodyRenew  = "سرویس شما با موفقیت تمدید شد.\n\n"
                       . "یوزرنیم سرویس: {$successDataRenew['mb_user']}\n"
                       . "لینک اشتراک: {$successDataRenew['sub_full']}\n\n"
                       . "راهنما: diminet.ir\n";

        try {
            send_mail($email, $subject_renew, $htmlBodyRenew, $altBodyRenew);
        } catch (Throwable $e) {
            error_log('MAIL_FAIL_RENEW_XUI: '.$e->getMessage());
        }

        render_success_page($successDataRenew);
    }

    // خرید جدید X-UI
    do {
        $random_number  = mt_rand(100000, 999999);
        $username_xui   = "Diminet.ir-$random_number";

        $stmtCheck = $pdo->prepare("SELECT id FROM services WHERE marzban_user = :u LIMIT 1");
        $stmtCheck->execute([':u' => $username_xui]);
        $exists = $stmtCheck->fetch(PDO::FETCH_ASSOC);
    } while ($exists);

    $payload = [
        'action'       => 'create_service',
        'server_id'    => $serverId,
        'inbound_id'   => $xuiInboundId,
        'client_email' => $username_xui,
        'total_gb'     => $data_limit_gb,
        'expire_days'  => $expire_days_for_xui,
    ];

    $ch = curl_init($xuiUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: application/json','Accept: application/json'],
        CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT        => 30,
    ]);
    $resp = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr  = curl_error($ch);
    curl_close($ch);

    if ($resp === false || $httpCode !== 200) {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'ساخت اکانت کامل نشد',
            "پرداخت شما ثبت شد ولی ارتباط با X-UI برای ساخت سرویس با مشکل مواجه شد.\nلطفاً با پشتیبانی تماس بگیر.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $json = json_decode($resp, true);
    if (!is_array($json) || empty($json['ok'])) {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'ساخت اکانت کامل نشد',
            "پرداخت شما ثبت شد ولی X-UI ساخت سرویس را تایید نکرد.\nلطفاً با پشتیبانی تماس بگیر.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $svcData = $json['service'] ?? [];
    $clientEmail = (string)($svcData['client_email'] ?? $username_xui);
    $clientUuid  = (string)($svcData['client_uuid'] ?? '');
    $subId       = (string)($svcData['sub_id'] ?? '');

    if ($clientEmail === '' || $clientUuid === '') {
        maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

        render_error_page(
            'ساخت اکانت کامل نشد',
            "پرداخت ثبت شد ولی اطلاعات سرویس X-UI کامل نیست.\nلطفاً با پشتیبانی تماس بگیر.",
            $payment['ref_id'] ?? '',
            $email,
            $siteUsername,
            $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
        );
    }

    $subscription_full = '';
    if ($subId !== '') {
        // اینجا هم مثل تمدید، از تابع استفاده می‌کنیم
        $subscription_full = build_xui_subscription_full($panelRow['base_url'] ?? '', $subId);
    }

    $expire_at   = date('Y-m-d H:i:s', $expire_ts_for_new);
    $expire_unix = $expire_ts_for_new;

    $insSvc = $pdo->prepare("
        INSERT INTO services
            (user_id, panel_id, marzban_user, marzban_uid, subscription_url,
             connection_info, plan_size_gb, expire_at, status, data_limit_bytes,
             used_bytes, up_bytes, down_bytes, expire_unix, inbound_tag, inbound_id,
             last_synced_at, created_at)
        VALUES
            (:uid, :pid, :muser, :muid, :sub,
             :conn, :sz, :exp_at, 'active', :limit,
             0, 0, 0, :exp_unix, NULL, :inb_id,
             NOW(), NOW())
    ");
    $insSvc->execute([
        ':uid'      => $siteUserRow['id'],
        ':pid'      => $panelId,
        ':muser'    => $clientEmail,
        ':muid'     => $clientUuid,
        ':sub'      => $subscription_full,
        ':conn'     => json_encode($svcData, JSON_UNESCAPED_UNICODE),
        ':sz'       => $data_limit_gb,
        ':exp_at'   => $expire_at,
        ':limit'    => $data_limit_bytes,
        ':exp_unix' => $expire_unix,
        ':inb_id'   => $xuiInboundId,
    ]);
    $serviceId = (int)$pdo->lastInsertId();

    if ($walletUsed > 0) {
        wallet_spend_for_service(
            $pdo,
            (int)$siteUserRow['id'],
            $walletUsed,
            $serviceId,
            (int)$payment['id'],
            'خرید سرویس X-UI با استفاده از کیف پول'
        );
    }

    $successDataNew = [
      'title'     => 'پرداخت موفق بود 🎉',
      'ref_id'    => $payment['ref_id'] ?? '',
      'email'     => $email,
      'plan'      => $plan['title'] ?? $planCode,
      'mb_user'   => $clientEmail,
      'sub_full'  => $subscription_full,
      'site_user' => $siteUsername,
      'site_pass' => $isNewSiteUser && $plainSitePass ? $plainSitePass : '',
    ];

    $subject_new   = "Diminet VPN";
    $htmlBodyNew   = build_success_email_html($successDataNew);
    $altBodyNew    = "خرید شما با موفقیت انجام شد.\n\n"
                   . "یوزرنیم سرویس: {$successDataNew['mb_user']}\n"
                   . "لینک اشتراک: {$successDataNew['sub_full']}\n"
                   . "یوزرنیم سایت: {$successDataNew['site_user']}\n"
                   . ($successDataNew['site_pass'] !== '' ? "رمز سایت: {$successDataNew['site_pass']}\n" : "")
                   . "\nراهنما: diminet.ir\n";

    try {
        send_mail($email, $subject_new, $htmlBodyNew, $altBodyNew);
    } catch (Throwable $e) {
        error_log('MAIL_FAIL_NEW_XUI: '.$e->getMessage());
    }

    render_success_page($successDataNew);
}

// اگر به اینجا رسیدیم یعنی نوع سرور پشتیبانی نشده
maybe_convert_payment_to_wallet($pdo, $payment, $siteUserRow);

render_error_page(
    'نوع سرور پشتیبانی نشده',
    "پرداختت موفق است ولی برای این نوع پنل هنوز اتصال خودکار پیاده‌سازی نشده.\nفعلاً با پشتیبانی تماس بگیر تا برات دستی سرویس بسازن.",
    $payment['ref_id'] ?? '',
    $email,
    $siteUsername,
    $isNewSiteUser && $plainSitePass ? $plainSitePass : ''
);
