<?php
// /app/api/plans.php
session_start();
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/../../db.php';

try {
    // فقط پلن‌های فعال
    $stmt = $pdo->query("
        SELECT
            id,
            code,
            title,
            amount_rial,
            amount_old_rial,
            imgurl,
            imgurlmob,
            plan_desc,
            is_recommended
        FROM plans
        WHERE is_active = 1
        ORDER BY
            COALESCE(sort_order, 9999) ASC,
            amount_rial ASC
    ");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];

    echo json_encode([
        'ok'    => true,
        'plans' => $rows,
    ], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'reason' => 'db_error']);
}
